/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.metrics.PercentileValue;
import org.ballerinalang.jvm.observability.metrics.Snapshot;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.observe.nativeimpl.ObserveNativeImplConstants;

public class Utils {
    private static final BType STATISTIC_CONFIG_TYPE = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "StatisticConfig").getType();
    private static final BType PERCENTILE_VALUE_TYPE = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "PercentileValue").getType();
    private static final BType SNAPSHOT_TYPE = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "Snapshot").getType();

    public static Map<String, String> toStringMap(MapValue<?, ?> map2) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (map2 != null) {
            for (Map.Entry keyVals : map2.entrySet()) {
                Object value2 = keyVals.getValue();
                returnMap.put(keyVals.getKey().toString(), value2 == null ? "()" : value2.toString());
            }
        }
        return returnMap;
    }

    public static ArrayValue createBSnapshots(Snapshot[] snapshots2, Strand strand) {
        if (snapshots2 != null && snapshots2.length > 0) {
            ArrayValueImpl bSnapshots = new ArrayValueImpl(new BArrayType(SNAPSHOT_TYPE));
            int index = 0;
            for (Snapshot snapshot : snapshots2) {
                ArrayValueImpl bPercentiles = new ArrayValueImpl(new BArrayType(PERCENTILE_VALUE_TYPE));
                int percentileIndex = 0;
                for (PercentileValue percentileValue : snapshot.getPercentileValues()) {
                    MapValue<String, Object> bPercentileValue = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "PercentileValue");
                    bPercentileValue.put("percentile", percentileValue.getPercentile());
                    bPercentileValue.put("value", percentileValue.getValue());
                    bPercentiles.add((long)percentileIndex, bPercentileValue);
                    ++percentileIndex;
                }
                MapValue<String, Object> aSnapshot = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "Snapshot");
                aSnapshot.put("timeWindow", snapshot.getTimeWindow().toMillis());
                aSnapshot.put("mean", snapshot.getMean());
                aSnapshot.put("max", snapshot.getMax());
                aSnapshot.put("min", snapshot.getMin());
                aSnapshot.put("stdDev", snapshot.getStdDev());
                aSnapshot.put("percentileValues", bPercentiles);
                bSnapshots.add((long)index, aSnapshot);
                ++index;
            }
            return bSnapshots;
        }
        return null;
    }

    public static ArrayValue createBStatisticConfig(StatisticConfig[] configs) {
        if (configs != null) {
            ArrayValueImpl bStatsConfig = new ArrayValueImpl(new BArrayType(STATISTIC_CONFIG_TYPE));
            int index = 0;
            for (StatisticConfig config : configs) {
                ArrayValueImpl bPercentiles = new ArrayValueImpl(new BArrayType(BTypes.typeFloat));
                int percentileIndex = 0;
                double[] dArray = config.getPercentiles();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double percentile = dArray[i];
                    bPercentiles.add((long)percentileIndex, percentile);
                    ++percentileIndex;
                }
                MapValue<String, Object> aSnapshot = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "StatisticConfig");
                aSnapshot.put("percentiles", bPercentiles);
                aSnapshot.put("timeWindow", config.getTimeWindow());
                aSnapshot.put("buckets", config.getBuckets());
                bStatsConfig.add((long)index, aSnapshot);
                ++index;
            }
            return bStatsConfig;
        }
        return new ArrayValueImpl(new BArrayType(STATISTIC_CONFIG_TYPE));
    }
}

