/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.trace.extension.zipkin;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.ResourceAttributes;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.InvalidConfigurationException;
import org.ballerinalang.jvm.observability.tracer.spi.TracerProvider;
import org.ballerinalang.observe.trace.extension.zipkin.sampler.RateLimitingSampler;

public class ZipkinTracerProvider
implements TracerProvider {
    private ConfigRegistry configRegistry;
    private String hostname;
    private int port;
    private String samplerType;
    private Number samplerParam;
    private int reporterFlushInterval;
    private int reporterBufferSize;
    private String apiContext;
    private String compressionMethod = "gzip";
    private static final PrintStream console = System.out;
    private SdkTracerProviderBuilder tracerProviderBuilder;

    @Override
    public String getName() {
        return "zipkin";
    }

    @Override
    public void init() throws InvalidConfigurationException {
        this.configRegistry = ConfigRegistry.getInstance();
        try {
            this.port = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.zipkin.reporter.port", String.valueOf(9411)));
            this.hostname = this.configRegistry.getConfigOrDefault("b7a.observability.tracing.zipkin.reporter.hostname", "localhost");
            this.apiContext = this.configRegistry.getConfigOrDefault(this.getFullQualifiedConfig("reporter.api.context"), "/api/v2/spans");
            boolean compressionEnabled = Boolean.parseBoolean(this.configRegistry.getConfigOrDefault(this.getFullQualifiedConfig("reporter.compression.enabled"), String.valueOf(true)));
            this.compressionMethod = compressionEnabled ? "gzip" : "none";
            this.samplerType = this.configRegistry.getConfigOrDefault("b7a.observability.tracing.zipkin.sampler.type", "const");
            this.samplerParam = Float.valueOf(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.zipkin.sampler.param", String.valueOf(1)));
            this.reporterFlushInterval = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.zipkin.reporter.flush.interval.ms", String.valueOf(1000)));
            this.reporterBufferSize = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.zipkin.reporter.max.buffer.spans", String.valueOf(10000)));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        String reporterEndpoint = "http://" + this.hostname + ":" + this.port + this.apiContext;
        ZipkinSpanExporter exporter = ZipkinSpanExporter.builder().setEndpoint(reporterEndpoint).setCompression(this.compressionMethod).build();
        this.tracerProviderBuilder = SdkTracerProvider.builder().addSpanProcessor(BatchSpanProcessor.builder(exporter).setMaxExportBatchSize(this.reporterBufferSize).setExporterTimeout(this.reporterFlushInterval, TimeUnit.MILLISECONDS).build());
        this.tracerProviderBuilder.setSampler(ZipkinTracerProvider.selectSampler(this.samplerType, this.samplerParam));
        console.println("ballerina: started publishing traces to Zipkin on " + reporterEndpoint);
    }

    private static Sampler selectSampler(String samplerType, Number samplerParam) {
        switch (samplerType) {
            default: {
                if (samplerParam.intValue() == 0) {
                    return Sampler.alwaysOff();
                }
                return Sampler.alwaysOn();
            }
            case "probabilistic": {
                return Sampler.traceIdRatioBased(samplerParam.doubleValue());
            }
            case "ratelimiting": 
        }
        return new RateLimitingSampler(samplerParam.intValue());
    }

    private String getFullQualifiedConfig(String configName) {
        return "b7a.observability.tracing.zipkin." + configName;
    }

    @Override
    public Tracer getTracer(String serviceName) {
        return this.tracerProviderBuilder.setResource(Resource.create(Attributes.of(ResourceAttributes.SERVICE_NAME, serviceName))).build().get("zipkin");
    }

    @Override
    public ContextPropagators getPropagators() {
        return ContextPropagators.create(B3Propagator.injectingSingleHeader());
    }
}

