/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.toml.antlr4;

import java.io.PrintStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class TomlErrorListener
extends BaseErrorListener {
    private static TomlErrorListener errorListener = null;
    private static PrintStream errStream = System.err;
    private String filePath;

    private TomlErrorListener(String filePath) {
        this.filePath = filePath;
    }

    public static TomlErrorListener getErrorListener(String tomlFilePath) {
        if (errorListener == null) {
            errorListener = new TomlErrorListener(tomlFilePath);
        }
        return errorListener;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.filePath == null) {
            return;
        }
        String errorMsg = "invalid toml syntax at " + this.filePath + ":" + line;
        errStream.println("error: " + errorMsg);
        Runtime.getRuntime().exit(1);
    }
}

