/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterTableRenameColumn
extends SchemaCommand {
    private boolean ifTableExists;
    private String tableName;
    private String oldName;
    private String newName;

    public AlterTableRenameColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    public void setTableName(String string2) {
        this.tableName = string2;
    }

    public void setOldColumnName(String string2) {
        this.oldName = string2;
    }

    public void setNewColumnName(String string2) {
        this.newName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table2 = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table2 == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        Column column = table2.getColumn(this.oldName);
        this.session.getUser().checkRight(table2, 15);
        table2.checkSupportAlter();
        Expression expression = column.getCheckConstraint(this.session, this.newName);
        table2.renameColumn(column, this.newName);
        column.removeCheckConstraint();
        column.addCheckConstraint(this.session, expression);
        table2.setModified();
        database.updateMeta(this.session, table2);
        for (DbObject dbObject : table2.getChildren()) {
            if (!(dbObject instanceof ConstraintReferential)) continue;
            ConstraintReferential constraintReferential = (ConstraintReferential)dbObject;
            constraintReferential.updateOnTableColumnRename();
        }
        for (DbObject dbObject : table2.getChildren()) {
            if (dbObject.getCreateSQL() == null) continue;
            database.updateMeta(this.session, dbObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 16;
    }
}

