/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.schema.Sequence;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class SequenceValue
extends Expression {
    private final Sequence sequence;

    public SequenceValue(Sequence sequence2) {
        this.sequence = sequence2;
    }

    @Override
    public Value getValue(Session session) {
        ValueLong valueLong = ValueLong.get(this.sequence.getNext(session));
        session.setLastIdentity(valueLong);
        return valueLong;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_LONG;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(NEXT VALUE FOR ");
        return this.sequence.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
            case 0: 
            case 2: 
            case 5: 
            case 8: {
                return false;
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.sequence.getModificationId());
                return true;
            }
            case 7: {
                expressionVisitor.addDependency(this.sequence);
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public boolean isGeneratedKey() {
        return true;
    }
}

