/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.AbstractList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.index.IndexCondition;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInParameter
extends Condition {
    private final Database database;
    private Expression left;
    private final Parameter parameter;

    static Value getValue(Database database, Value value2, Value value3) {
        boolean bl = false;
        if (value3.containsNull()) {
            bl = true;
        } else if (value3.getValueType() == 18) {
            ResultInterface resultInterface = value3.getResult();
            while (resultInterface.next()) {
                Value value4 = resultInterface.currentRow()[0];
                Value value5 = Comparison.compare(database, value2, value4, 0);
                if (value5 == ValueNull.INSTANCE) {
                    bl = true;
                    continue;
                }
                if (value5 != ValueBoolean.TRUE) continue;
                return value5;
            }
        } else {
            for (Value value6 : ((ValueArray)value3.convertTo(17)).getList()) {
                Value value7 = Comparison.compare(database, value2, value6, 0);
                if (value7 == ValueNull.INSTANCE) {
                    bl = true;
                    continue;
                }
                if (value7 != ValueBoolean.TRUE) continue;
                return value7;
            }
        }
        if (bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.FALSE;
    }

    public ConditionInParameter(Database database, Expression expression, Parameter parameter) {
        this.database = database;
        this.left = expression;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(Session session) {
        Value value2 = this.left.getValue(session);
        if (value2 == ValueNull.INSTANCE) {
            return value2;
        }
        return ConditionInParameter.getValue(this.database, value2, this.parameter.getValue(session));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left == ValueExpression.getNull()) {
            return this.left;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" = ANY(");
        return this.parameter.getSQL(stringBuilder, bl).append("))");
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.parameter.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int n) {
            Value value2 = this.parameter.getParamValue();
            if (value2 instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value2).getList()[n]);
            }
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value2);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value2 = this.parameter.getParamValue();
            if (value2 instanceof ValueArray) {
                return ((ValueArray)value2).getList().length;
            }
            return 1;
        }
    }
}

