/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.h2.api.ErrorCode;
import org.h2.jdbc.JdbcException;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceWriter;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

public class TraceSystem
implements TraceWriter {
    public static final int PARENT = -1;
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int ADAPTER = 4;
    public static final int DEFAULT_TRACE_LEVEL_SYSTEM_OUT = 0;
    public static final int DEFAULT_TRACE_LEVEL_FILE = 1;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    private static final int CHECK_SIZE_EACH_WRITES = 4096;
    private int levelSystemOut = 0;
    private int levelFile = 1;
    private int levelMax;
    private int maxFileSize = 0x4000000;
    private String fileName;
    private final AtomicReferenceArray<Trace> traces = new AtomicReferenceArray(Trace.MODULE_NAMES.length);
    private SimpleDateFormat dateFormat;
    private Writer fileWriter;
    private PrintWriter printWriter;
    private int checkSize;
    private boolean closed;
    private boolean writingErrorLogged;
    private TraceWriter writer = this;
    private PrintStream sysOut = System.out;

    public TraceSystem(String string2) {
        this.fileName = string2;
        this.updateLevel();
    }

    private void updateLevel() {
        this.levelMax = Math.max(this.levelSystemOut, this.levelFile);
    }

    public void setSysOut(PrintStream printStream) {
        this.sysOut = printStream;
    }

    public Trace getTrace(int n) {
        Trace trace = this.traces.get(n);
        if (trace == null && !this.traces.compareAndSet(n, null, trace = new Trace(this.writer, n))) {
            trace = this.traces.get(n);
        }
        return trace;
    }

    public Trace getTrace(String string2) {
        return new Trace(this.writer, string2);
    }

    @Override
    public boolean isEnabled(int n) {
        if (this.levelMax == 4) {
            return this.writer.isEnabled(n);
        }
        return n <= this.levelMax;
    }

    public void setFileName(String string2) {
        this.fileName = string2;
    }

    public void setMaxFileSize(int n) {
        this.maxFileSize = n;
    }

    public void setLevelSystemOut(int n) {
        this.levelSystemOut = n;
        this.updateLevel();
    }

    public void setLevelFile(int n) {
        if (n == 4) {
            String string2 = "org.h2.message.TraceWriterAdapter";
            try {
                this.writer = (TraceWriter)Class.forName(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                DbException dbException = DbException.get(90086, throwable, string2);
                this.write(1, 2, string2, (Throwable)dbException);
                return;
            }
            String string3 = this.fileName;
            if (string3 != null) {
                int n2;
                if (string3.endsWith(".trace.db")) {
                    string3 = string3.substring(0, string3.length() - ".trace.db".length());
                }
                if ((n2 = Math.max(string3.lastIndexOf(47), string3.lastIndexOf(92))) >= 0) {
                    string3 = string3.substring(n2 + 1);
                }
                this.writer.setName(string3);
            }
        }
        this.levelFile = n;
        this.updateLevel();
    }

    public int getLevelFile() {
        return this.levelFile;
    }

    private synchronized String format(String string2, String string3) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
        }
        return this.dateFormat.format(System.currentTimeMillis()) + string2 + ": " + string3;
    }

    @Override
    public void write(int n, int n2, String string2, Throwable throwable) {
        this.write(n, Trace.MODULE_NAMES[n2], string2, throwable);
    }

    @Override
    public void write(int n, String string2, String string3, Throwable throwable) {
        if (n <= this.levelSystemOut || n > this.levelMax) {
            this.sysOut.println(this.format(string2, string3));
            if (throwable != null && this.levelSystemOut == 3) {
                throwable.printStackTrace(this.sysOut);
            }
        }
        if (this.fileName != null && n <= this.levelFile) {
            this.writeFile(this.format(string2, string3), throwable);
        }
    }

    private synchronized void writeFile(String string2, Throwable throwable) {
        try {
            Object object;
            if (this.checkSize++ >= 4096) {
                this.checkSize = 0;
                this.closeWriter();
                if (this.maxFileSize > 0 && FileUtils.size(this.fileName) > (long)this.maxFileSize) {
                    object = this.fileName + ".old";
                    FileUtils.delete((String)object);
                    FileUtils.move(this.fileName, (String)object);
                }
            }
            if (!this.openWriter()) {
                return;
            }
            this.printWriter.println(string2);
            if (throwable != null) {
                if (this.levelFile == 1 && throwable instanceof JdbcException) {
                    object = (JdbcException)((Object)throwable);
                    int n = object.getErrorCode();
                    if (ErrorCode.isCommon(n)) {
                        this.printWriter.println(throwable.toString());
                    } else {
                        throwable.printStackTrace(this.printWriter);
                    }
                } else {
                    throwable.printStackTrace(this.printWriter);
                }
            }
            this.printWriter.flush();
            if (this.closed) {
                this.closeWriter();
            }
        }
        catch (Exception exception) {
            this.logWritingError(exception);
        }
    }

    private void logWritingError(Exception exception) {
        if (this.writingErrorLogged) {
            return;
        }
        this.writingErrorLogged = true;
        DbException dbException = DbException.get(90034, exception, this.fileName, exception.toString());
        this.fileName = null;
        this.sysOut.println(dbException);
        dbException.printStackTrace();
    }

    private boolean openWriter() {
        if (this.printWriter == null) {
            try {
                FileUtils.createDirectories(FileUtils.getParent(this.fileName));
                if (FileUtils.exists(this.fileName) && !FileUtils.canWrite(this.fileName)) {
                    return false;
                }
                this.fileWriter = IOUtils.getBufferedWriter(FileUtils.newOutputStream(this.fileName, true));
                this.printWriter = new PrintWriter(this.fileWriter, true);
            }
            catch (Exception exception) {
                this.logWritingError(exception);
                return false;
            }
        }
        return true;
    }

    private synchronized void closeWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
            this.printWriter.close();
            this.printWriter = null;
        }
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileWriter = null;
        }
    }

    public void close() {
        this.closeWriter();
        this.closed = true;
    }

    @Override
    public void setName(String string2) {
    }
}

