/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileUtils;
import org.h2.table.TableBase;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class MVTableEngine
implements TableEngine {
    public static Store init(final Database database) {
        Store store = database.getStore();
        if (store != null) {
            return store;
        }
        byte[] byArray = database.getFileEncryptionKey();
        String string2 = database.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        store = new Store();
        boolean bl = false;
        if (string2 != null) {
            String string3 = string2 + ".mv.db";
            MVStoreTool.compactCleanUp(string3);
            builder.fileName(string3);
            builder.pageSplitSize(database.getPageSize());
            if (database.isReadOnly()) {
                builder.readOnly();
            } else {
                boolean bl2 = FileUtils.exists(string3);
                if (!bl2 || FileUtils.canWrite(string3)) {
                    String string4 = FileUtils.getParent(string3);
                    FileUtils.createDirectories(string4);
                }
            }
            if (byArray != null) {
                bl = true;
                builder.encryptionKey(MVTableEngine.decodePassword(byArray));
            }
            if (database.getSettings().compressData) {
                builder.compress();
                builder.pageSplitSize(65536);
            }
            builder.backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread2, Throwable throwable) {
                    database.setBackgroundException(DbException.convert(throwable));
                }
            });
        }
        store.open(database, builder, bl);
        database.setStore(store);
        return store;
    }

    static char[] decodePassword(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((byArray[i + i] & 0xFF) << 16 | byArray[i + i + 1] & 0xFF);
        }
        return cArray;
    }

    @Override
    public TableBase createTable(CreateTableData createTableData) {
        Database database = createTableData.session.getDatabase();
        Store store = MVTableEngine.init(database);
        return store.createTable(createTableData);
    }

    private static class MVInDoubtTransaction
    implements InDoubtTransaction {
        private final MVStore store;
        private final Transaction transaction;
        private int state = 0;

        MVInDoubtTransaction(MVStore mVStore, Transaction transaction) {
            this.store = mVStore;
            this.transaction = transaction;
        }

        @Override
        public void setState(int n) {
            if (n == 1) {
                this.transaction.commit();
            } else {
                this.transaction.rollback();
            }
            this.store.commit();
            this.state = n;
        }

        @Override
        public String getState() {
            switch (this.state) {
                case 0: {
                    return "IN_DOUBT";
                }
                case 1: {
                    return "COMMIT";
                }
                case 2: {
                    return "ROLLBACK";
                }
            }
            throw DbException.throwInternalError("state=" + this.state);
        }

        @Override
        public String getTransactionName() {
            return this.transaction.getName();
        }
    }

    public static class Store {
        private final ConcurrentHashMap<String, MVTable> tableMap = new ConcurrentHashMap();
        private MVStore mvStore;
        private TransactionStore transactionStore;
        private long statisticsStart;
        private int temporaryMapId;
        private boolean encrypted;
        private String fileName;

        void open(Database database, MVStore.Builder builder, boolean bl) {
            this.encrypted = bl;
            try {
                this.mvStore = builder.open();
                FileStore fileStore = this.mvStore.getFileStore();
                if (fileStore != null) {
                    this.fileName = fileStore.getFileName();
                }
                if (!database.getSettings().reuseSpace) {
                    this.mvStore.setReuseSpace(false);
                }
                this.transactionStore = new TransactionStore(this.mvStore, new ValueDataType(database, null), database.getLockTimeout());
            }
            catch (IllegalStateException illegalStateException) {
                throw this.convertIllegalStateException(illegalStateException);
            }
        }

        DbException convertIllegalStateException(IllegalStateException illegalStateException) {
            int n = DataUtils.getErrorCode(illegalStateException.getMessage());
            if (n == 6) {
                if (this.encrypted) {
                    throw DbException.get(90049, illegalStateException, this.fileName);
                }
            } else {
                if (n == 7) {
                    throw DbException.get(90020, illegalStateException, this.fileName);
                }
                if (n == 1) {
                    throw DbException.get(90028, illegalStateException, this.fileName);
                }
                if (n == 3) {
                    throw DbException.get(50000, illegalStateException, this.fileName);
                }
            }
            throw DbException.get(90030, illegalStateException, this.fileName);
        }

        public MVStore getMvStore() {
            return this.mvStore;
        }

        public TransactionStore getTransactionStore() {
            return this.transactionStore;
        }

        public MVTable getTable(String string2) {
            return this.tableMap.get(string2);
        }

        public MVTable createTable(CreateTableData createTableData) {
            MVTable mVTable = new MVTable(createTableData, this);
            this.tableMap.put(mVTable.getMapName(), mVTable);
            return mVTable;
        }

        public void removeTable(MVTable mVTable) {
            this.tableMap.remove(mVTable.getMapName());
        }

        public void flush() {
            FileStore fileStore = this.mvStore.getFileStore();
            if (fileStore == null || fileStore.isReadOnly()) {
                return;
            }
            if (!this.mvStore.compact(50, 0x400000)) {
                this.mvStore.commit();
            }
        }

        public void closeImmediately() {
            if (this.mvStore.isClosed()) {
                return;
            }
            this.mvStore.closeImmediately();
        }

        public void removeTemporaryMaps(BitSet bitSet) {
            for (String string2 : this.mvStore.getMapNames()) {
                int n;
                if (string2.startsWith("temp.")) {
                    this.mvStore.removeMap(string2);
                    continue;
                }
                if (!string2.startsWith("table.") && !string2.startsWith("index.") || bitSet.get(n = StringUtils.parseUInt31(string2, string2.indexOf(46) + 1, string2.length()))) continue;
                this.mvStore.removeMap(string2);
            }
        }

        public synchronized String nextTemporaryMapName() {
            return "temp." + this.temporaryMapId++;
        }

        public void prepareCommit(Session session, String string2) {
            Transaction transaction = session.getTransaction();
            transaction.setName(string2);
            transaction.prepare();
            this.mvStore.commit();
        }

        public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
            List<Transaction> list = this.transactionStore.getOpenTransactions();
            ArrayList<InDoubtTransaction> arrayList = Utils.newSmallArrayList();
            for (Transaction transaction : list) {
                if (transaction.getStatus() != 2) continue;
                arrayList.add(new MVInDoubtTransaction(this.mvStore, transaction));
            }
            return arrayList;
        }

        public void setCacheSize(int n) {
            this.mvStore.setCacheSize(Math.max(1, n / 1024));
        }

        public InputStream getInputStream() {
            FileChannel fileChannel = this.mvStore.getFileStore().getEncryptedFile();
            if (fileChannel == null) {
                fileChannel = this.mvStore.getFileStore().getFile();
            }
            return new FileChannelInputStream(fileChannel, false);
        }

        public void sync() {
            this.flush();
            this.mvStore.sync();
        }

        public void compactFile(long l) {
            this.mvStore.setRetentionTime(0);
            long l2 = System.nanoTime();
            while (this.mvStore.compact(95, 0x1000000)) {
                this.mvStore.sync();
                this.mvStore.compactMoveChunks(95, 0x1000000L);
                long l3 = System.nanoTime() - l2;
                if (l3 <= TimeUnit.MILLISECONDS.toNanos(l)) continue;
                break;
            }
        }

        public void close(boolean bl) {
            try {
                FileStore fileStore = this.mvStore.getFileStore();
                if (!this.mvStore.isClosed() && fileStore != null) {
                    if (fileStore.isReadOnly()) {
                        bl = false;
                    } else {
                        this.transactionStore.close();
                    }
                    String string2 = fileStore.getFileName();
                    this.mvStore.close();
                    if (bl && FileUtils.exists(string2)) {
                        MVStoreTool.compact(string2, true);
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                int n = DataUtils.getErrorCode(illegalStateException.getMessage());
                if (n == 2 || n == 6) {
                    // empty if block
                }
                this.mvStore.closeImmediately();
                throw DbException.get(90028, illegalStateException, "Closing");
            }
        }

        public void statisticsStart() {
            FileStore fileStore = this.mvStore.getFileStore();
            this.statisticsStart = fileStore == null ? 0L : fileStore.getReadCount();
        }

        public Map<String, Integer> statisticsEnd() {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            FileStore fileStore = this.mvStore.getFileStore();
            int n = fileStore == null ? 0 : (int)(fileStore.getReadCount() - this.statisticsStart);
            hashMap.put("reads", n);
            return hashMap;
        }
    }
}

