/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.h2.security.auth.AuthConfigException;
import org.h2.security.auth.PropertyConfig;
import org.h2.util.Utils;

public class ConfigProperties {
    private Map<String, String> properties = new HashMap<String, String>();

    public ConfigProperties() {
    }

    public ConfigProperties(PropertyConfig ... propertyConfigArray) {
        this(propertyConfigArray == null ? null : Arrays.asList(propertyConfigArray));
    }

    public ConfigProperties(Collection<PropertyConfig> collection) {
        if (this.properties != null) {
            for (PropertyConfig propertyConfig : collection) {
                if (this.properties.put(propertyConfig.getName(), propertyConfig.getValue()) == null) continue;
                throw new AuthConfigException("duplicate property " + propertyConfig.getName());
            }
        }
    }

    public String getStringValue(String string2, String string3) {
        String string4 = this.properties.get(string2);
        if (string4 == null) {
            return string3;
        }
        return string4;
    }

    public String getStringValue(String string2) {
        String string3 = this.properties.get(string2);
        if (string3 == null) {
            throw new AuthConfigException("missing config property " + string2);
        }
        return string3;
    }

    public int getIntValue(String string2, int n) {
        String string3 = this.properties.get(string2);
        if (string3 == null) {
            return n;
        }
        return Integer.parseInt(string3);
    }

    public int getIntValue(String string2) {
        String string3 = this.properties.get(string2);
        if (string3 == null) {
            throw new AuthConfigException("missing config property " + string2);
        }
        return Integer.parseInt(string3);
    }

    public boolean getBooleanValue(String string2, boolean bl) {
        String string3 = this.properties.get(string2);
        if (string3 == null) {
            return bl;
        }
        return Utils.parseBoolean(string3, bl, true);
    }
}

