/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

class WebThread
extends WebApp
implements Runnable {
    protected OutputStream output;
    protected final Socket socket;
    private final Thread thread;
    private InputStream input;
    private String ifModifiedSince;

    WebThread(Socket socket, WebServer webServer) {
        super(webServer);
        this.socket = socket;
        this.thread = new Thread((Runnable)this, "H2 Console thread");
    }

    void start() {
        this.thread.start();
    }

    void join(int n) throws InterruptedException {
        this.thread.join(n);
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String string2) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (string2.length() == 0) {
            return "index.do";
        }
        if (string2.charAt(0) == '?') {
            return "index.do" + string2;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop && this.process()) {
            }
        }
        catch (Exception exception) {
            DbException.traceThrowable(exception);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException {
        boolean bl = false;
        String string2 = this.readHeaderLine();
        if (string2.startsWith("GET ") || string2.startsWith("POST ")) {
            byte[] byArray;
            String string3;
            String string4;
            int n = string2.indexOf(47);
            int n2 = string2.lastIndexOf(32);
            String string5 = n < 0 || n2 < n ? "" : StringUtils.trimSubstring(string2, n + 1, n2);
            this.trace(string2 + ": " + string5);
            string5 = this.getAllowedFile(string5);
            this.attributes = new Properties();
            int n3 = string5.indexOf(63);
            this.session = null;
            String string6 = null;
            if (n3 >= 0) {
                string4 = string5.substring(n3 + 1);
                this.parseAttributes(string4);
                string3 = this.attributes.getProperty("jsessionid");
                string6 = this.attributes.getProperty("key");
                string5 = string5.substring(0, n3);
                this.session = this.server.getSession(string3);
            }
            bl = this.parseHeader();
            string4 = this.socket.getInetAddress().getHostAddress();
            if ((string5 = this.processRequest(string5, string4)).length() == 0) {
                return true;
            }
            if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                byArray = null;
                string3 = "HTTP/1.1 304 Not Modified\r\n";
            } else {
                byArray = this.server.getFile(string5);
                if (byArray == null) {
                    string3 = "HTTP/1.1 404 Not Found\r\n";
                    byArray = ("File not found: " + string5).getBytes(StandardCharsets.UTF_8);
                    string3 = string3 + "Content-Length: " + byArray.length + "\r\n";
                } else {
                    if (this.session != null && string5.endsWith(".jsp")) {
                        Iterator iterator2;
                        if (string6 != null) {
                            this.session.put("key", string6);
                        }
                        String string7 = new String(byArray, StandardCharsets.UTF_8);
                        if (SysProperties.CONSOLE_STREAM && (iterator2 = (Iterator)this.session.map.remove("chunks")) != null) {
                            string3 = "HTTP/1.1 200 OK\r\n";
                            string3 = string3 + "Content-Type: " + this.mimeType + "\r\n";
                            string3 = string3 + "Cache-Control: no-cache\r\n";
                            string3 = string3 + "Transfer-Encoding: chunked\r\n";
                            string3 = string3 + "\r\n";
                            this.trace(string3);
                            this.output.write(string3.getBytes());
                            while (iterator2.hasNext()) {
                                String string8 = (String)iterator2.next();
                                byArray = (string8 = PageParser.parse(string8, this.session.map)).getBytes(StandardCharsets.UTF_8);
                                if (byArray.length == 0) continue;
                                this.output.write(Integer.toHexString(byArray.length).getBytes());
                                this.output.write("\r\n".getBytes());
                                this.output.write(byArray);
                                this.output.write("\r\n".getBytes());
                                this.output.flush();
                            }
                            this.output.write("0\r\n\r\n".getBytes());
                            this.output.flush();
                            return bl;
                        }
                        string7 = PageParser.parse(string7, this.session.map);
                        byArray = string7.getBytes(StandardCharsets.UTF_8);
                    }
                    string3 = "HTTP/1.1 200 OK\r\n";
                    string3 = string3 + "Content-Type: " + this.mimeType + "\r\n";
                    if (!this.cache) {
                        string3 = string3 + "Cache-Control: no-cache\r\n";
                    } else {
                        string3 = string3 + "Cache-Control: max-age=10\r\n";
                        string3 = string3 + "Last-Modified: " + this.server.getStartDateTime() + "\r\n";
                    }
                    string3 = string3 + "Content-Length: " + byArray.length + "\r\n";
                }
            }
            string3 = string3 + "\r\n";
            this.trace(string3);
            this.output.write(string3.getBytes());
            if (byArray != null) {
                this.output.write(byArray);
            }
            this.output.flush();
        }
        return bl;
    }

    private String readHeaderLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 13) {
                if (this.input.read() != 10) continue;
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            if (n == 10) {
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            stringBuilder.append((char)n);
        }
    }

    private void parseAttributes(String string2) {
        int n;
        this.trace("data=" + string2);
        while (string2 != null && (n = string2.indexOf(61)) >= 0) {
            String string3;
            String string4 = string2.substring(0, n);
            if ((n = (string2 = string2.substring(n + 1)).indexOf(38)) >= 0) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            } else {
                string3 = string2;
            }
            String string5 = StringUtils.urlDecode(string3);
            this.attributes.put(string4, string5);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        Object object;
        boolean bl = false;
        this.trace("parseHeader");
        int n = 0;
        this.ifModifiedSince = null;
        boolean bl2 = false;
        block0: while ((object = this.readHeaderLine()) != null) {
            this.trace(" " + (String)object);
            String string2 = StringUtils.toLowerEnglish((String)object);
            if (string2.startsWith("if-modified-since")) {
                this.ifModifiedSince = WebThread.getHeaderLineValue((String)object);
                continue;
            }
            if (string2.startsWith("connection")) {
                String string3 = WebThread.getHeaderLineValue((String)object);
                if (!"keep-alive".equals(string3)) continue;
                bl = true;
                continue;
            }
            if (string2.startsWith("content-type")) {
                String string4 = WebThread.getHeaderLineValue((String)object);
                if (!string4.startsWith("multipart/form-data")) continue;
                bl2 = true;
                continue;
            }
            if (string2.startsWith("content-length")) {
                n = Integer.parseInt(WebThread.getHeaderLineValue((String)object));
                this.trace("len=" + n);
                continue;
            }
            if (string2.startsWith("user-agent")) {
                boolean bl3 = string2.contains("webkit/");
                if (!bl3 || this.session == null) continue;
                this.session.put("frame-border", "1");
                this.session.put("frameset-border", "2");
                continue;
            }
            if (string2.startsWith("accept-language")) {
                Locale locale = this.session == null ? null : this.session.locale;
                if (locale != null) continue;
                String string5 = WebThread.getHeaderLineValue((String)object);
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",;");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (string6.startsWith("q=") || !this.server.supportsLanguage(string6)) continue;
                    int n2 = string6.indexOf(45);
                    if (n2 >= 0) {
                        String string7 = string6.substring(0, n2);
                        String string8 = string6.substring(n2 + 1);
                        locale = new Locale(string7, string8);
                    } else {
                        locale = new Locale(string6, "");
                    }
                    this.headerLanguage = locale.getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = locale;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (!StringUtils.isWhitespaceOrEmpty((String)object)) continue;
            break;
        }
        if (!bl2 && this.session != null && n > 0) {
            object = Utils.newBytes(n);
            for (int i = 0; i < n; i += this.input.read((byte[])object, i, n - i)) {
            }
            String string9 = new String((byte[])object);
            this.parseAttributes(string9);
        }
        return bl;
    }

    private static String getHeaderLineValue(String string2) {
        return StringUtils.trimSubstring(string2, string2.indexOf(58) + 1);
    }

    @Override
    protected String adminShutdown() {
        this.stopNow();
        return super.adminShutdown();
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(this.socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.server.traceError(unknownHostException);
            return false;
        }
    }

    private void trace(String string2) {
        this.server.trace(string2);
    }
}

