/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class ValueFloat
extends Value {
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    public static final int ZERO_BITS = 0;
    public static final ValueFloat ZERO = new ValueFloat(0.0f);
    public static final ValueFloat ONE = new ValueFloat(1.0f);
    private static final ValueFloat NAN = new ValueFloat(Float.NaN);
    private final float value;

    private ValueFloat(float f) {
        this.value = f;
    }

    @Override
    public Value add(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return ValueFloat.get(this.value + valueFloat.value);
    }

    @Override
    public Value subtract(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return ValueFloat.get(this.value - valueFloat.value);
    }

    @Override
    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    @Override
    public Value multiply(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return ValueFloat.get(this.value * valueFloat.value);
    }

    @Override
    public Value divide(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        if ((double)valueFloat.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / valueFloat.value);
    }

    @Override
    public Value modulus(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        if (valueFloat.value == 0.0f) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value % valueFloat.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        if (this.value == Float.POSITIVE_INFINITY) {
            stringBuilder.append("POWER(0, -1)");
        } else if (this.value == Float.NEGATIVE_INFINITY) {
            stringBuilder.append("(-POWER(0, -1))");
        } else if (Float.isNaN(this.value)) {
            stringBuilder.append("SQRT(-1)");
        } else {
            stringBuilder.append(this.value);
        }
        return stringBuilder;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_FLOAT;
    }

    @Override
    public int getValueType() {
        return 8;
    }

    @Override
    public int compareTypeSafe(Value value2, CompareMode compareMode) {
        return Float.compare(this.value, ((ValueFloat)value2).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return Float.toString(this.value);
    }

    @Override
    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setFloat(n, this.value);
    }

    public static ValueFloat get(float f) {
        if (f == 1.0f) {
            return ONE;
        }
        if (f == 0.0f) {
            return ZERO;
        }
        if (Float.isNaN(f)) {
            return NAN;
        }
        return (ValueFloat)Value.cache(new ValueFloat(f));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueFloat)) {
            return false;
        }
        return this.compareTypeSafe((ValueFloat)object, null) == 0;
    }
}

