/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 128;
    private static final int DYNAMIC_SIZE = 256;
    private static final ValueInt[] STATIC_CACHE = new ValueInt[128];
    private static final ValueInt[] DYNAMIC_CACHE = new ValueInt[256];
    private final int value;

    private ValueInt(int n) {
        this.value = n;
    }

    public static ValueInt get(int n) {
        if (n >= 0 && n < 128) {
            return STATIC_CACHE[n];
        }
        ValueInt valueInt = DYNAMIC_CACHE[n & 0xFF];
        if (valueInt == null || valueInt.value != n) {
            ValueInt.DYNAMIC_CACHE[n & 0xFF] = valueInt = new ValueInt(n);
        }
        return valueInt;
    }

    @Override
    public Value add(Value value2) {
        ValueInt valueInt = (ValueInt)value2;
        return ValueInt.checkRange((long)this.value + (long)valueInt.value);
    }

    private static ValueInt checkRange(long l) {
        if ((long)((int)l) != l) {
            throw DbException.get(22003, Long.toString(l));
        }
        return ValueInt.get((int)l);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueInt.checkRange(-((long)this.value));
    }

    @Override
    public Value subtract(Value value2) {
        ValueInt valueInt = (ValueInt)value2;
        return ValueInt.checkRange((long)this.value - (long)valueInt.value);
    }

    @Override
    public Value multiply(Value value2) {
        ValueInt valueInt = (ValueInt)value2;
        return ValueInt.checkRange((long)this.value * (long)valueInt.value);
    }

    @Override
    public Value divide(Value value2) {
        int n = ((ValueInt)value2).value;
        if (n == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        int n2 = this.value;
        if (n2 == Integer.MIN_VALUE && n == -1) {
            throw DbException.get(22003, "2147483648");
        }
        return ValueInt.get(n2 / n);
    }

    @Override
    public Value modulus(Value value2) {
        ValueInt valueInt = (ValueInt)value2;
        if (valueInt.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value % valueInt.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_INT;
    }

    @Override
    public int getValueType() {
        return 4;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value value2, CompareMode compareMode) {
        return Integer.compare(this.value, ((ValueInt)value2).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(n, this.value);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueInt && this.value == ((ValueInt)object).value;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ValueInt.STATIC_CACHE[i] = new ValueInt(i);
        }
    }
}

