/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class ValueStringIgnoreCase
extends ValueString {
    private static final ValueStringIgnoreCase EMPTY = new ValueStringIgnoreCase("");
    private int hash;

    protected ValueStringIgnoreCase(String string2) {
        super(string2);
    }

    @Override
    public int getValueType() {
        return 14;
    }

    @Override
    public int compareTypeSafe(Value value2, CompareMode compareMode) {
        return compareMode.compareString(this.value, ((ValueStringIgnoreCase)value2).value, true);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueString && this.value.equalsIgnoreCase(((ValueString)object).value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.toUpperCase().hashCode();
        }
        return this.hash;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("CAST(");
        return StringUtils.quoteStringSQL(stringBuilder, this.value).append(" AS VARCHAR_IGNORECASE)");
    }

    public static ValueStringIgnoreCase get(String string2) {
        int n = string2.length();
        if (n == 0) {
            return EMPTY;
        }
        ValueStringIgnoreCase valueStringIgnoreCase = new ValueStringIgnoreCase(StringUtils.cache(string2));
        if (n > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueStringIgnoreCase;
        }
        ValueStringIgnoreCase valueStringIgnoreCase2 = (ValueStringIgnoreCase)Value.cache(valueStringIgnoreCase);
        if (valueStringIgnoreCase2.value.equals(string2)) {
            return valueStringIgnoreCase2;
        }
        return valueStringIgnoreCase;
    }

    @Override
    protected ValueString getNew(String string2) {
        return ValueStringIgnoreCase.get(string2);
    }
}

