/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext;

import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;

@Singleton
@Named
public final class DefaultSyncContextFactory
implements SyncContextFactory,
Service {
    private NamedLockFactoryAdapter namedLockFactoryAdapter;

    @Inject
    public DefaultSyncContextFactory(NamedLockFactorySelector selector) {
        this.namedLockFactoryAdapter = new NamedLockFactoryAdapter(selector.getSelectedNameMapper(), selector.getSelectedNamedLockFactory());
    }

    public DefaultSyncContextFactory() {
    }

    @Override
    public void initService(ServiceLocator locator) {
        NamedLockFactorySelector selector = Objects.requireNonNull(locator.getService(NamedLockFactorySelector.class));
        this.namedLockFactoryAdapter = new NamedLockFactoryAdapter(selector.getSelectedNameMapper(), selector.getSelectedNamedLockFactory());
    }

    @Override
    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Objects.requireNonNull(session, "session cannot be null");
        return this.namedLockFactoryAdapter.newInstance(session, shared);
    }

    @PreDestroy
    public void shutdown() {
        this.namedLockFactoryAdapter.shutdown();
    }
}

