/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authentication.sasl.plain;

import io.ballerina.messaging.broker.auth.authentication.Authenticator;
import io.ballerina.messaging.broker.auth.authentication.sasl.plain.PlainSaslServer;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class PlainSaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Authenticator authenticator = (Authenticator)props.get("broker.authenticator");
        return "PLAIN".equals(mechanism) ? new PlainSaslServer(authenticator) : null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props != null && "true".equals(props.get("javax.security.sasl.policy.noplaintext"))) {
            return new String[0];
        }
        return new String[]{"PLAIN"};
    }
}

