/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization;

import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.common.StartupContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class DiscretionaryAccessController {
    public abstract void initialize(StartupContext var1, UserStore var2, Map<String, String> var3) throws Exception;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean authorize(String resourceType, String resource, String action, String userId, Set<String> userGroups) throws AuthServerException, AuthNotFoundException {
        AuthResource authResource = this.getAuthResource(resourceType, resource);
        if (Objects.isNull(authResource)) {
            return false;
        }
        if (authResource.getOwner().equals(userId)) {
            return true;
        }
        Set<String> userGroupsForAction = authResource.getActionsUserGroupsMap().get(action);
        if (!Objects.nonNull(userGroupsForAction)) return false;
        if (!userGroupsForAction.stream().anyMatch(userGroups::contains)) return false;
        return true;
    }

    public abstract void addResource(String var1, String var2, String var3) throws AuthServerException;

    public abstract boolean deleteResource(String var1, String var2) throws AuthServerException, AuthNotFoundException;

    public abstract boolean addGroupsToResource(String var1, String var2, String var3, List<String> var4) throws AuthServerException;

    public abstract boolean removeGroupFromResource(String var1, String var2, String var3, String var4) throws AuthServerException, AuthNotFoundException;

    public abstract boolean changeResourceOwner(String var1, String var2, String var3) throws AuthServerException, AuthNotFoundException;

    public abstract AuthResource getAuthResource(String var1, String var2) throws AuthServerException, AuthNotFoundException;
}

