/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.email.client;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.email.util.EmailAccessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAccessClient {
    private static final Logger log = LoggerFactory.getLogger(EmailAccessClient.class);

    private EmailAccessClient() {
    }

    public static Object initPopClientEndpoint(ObjectValue clientEndpoint, String host, String username, String password, MapValue<Object, Object> config) {
        Properties properties = EmailAccessUtil.getPopProperties(config, host);
        Session session = Session.getInstance((Properties)properties, null);
        try {
            Store store = session.getStore("pop3");
            clientEndpoint.addNativeData("store", (Object)store);
            clientEndpoint.addNativeData("host", (Object)host);
            clientEndpoint.addNativeData("username", (Object)username);
            clientEndpoint.addNativeData("password", (Object)password);
            return null;
        }
        catch (NoSuchProviderException e) {
            log.error("Failed initialize client properties : ", (Throwable)e);
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)"{ballerina/email}ReadClientInitError"), (String)e.getMessage());
        }
    }

    public static Object initImapClientEndpoint(ObjectValue clientEndpoint, String host, String username, String password, MapValue<Object, Object> config) {
        Properties properties = EmailAccessUtil.getImapProperties(config, host);
        Session session = Session.getInstance((Properties)properties, null);
        try {
            Store store = session.getStore("imap");
            clientEndpoint.addNativeData("store", (Object)store);
            clientEndpoint.addNativeData("host", (Object)host);
            clientEndpoint.addNativeData("username", (Object)username);
            clientEndpoint.addNativeData("password", (Object)password);
            return null;
        }
        catch (NoSuchProviderException e) {
            log.error("Failed initialize client properties : ", (Throwable)e);
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)"{ballerina/email}ReadClientInitError"), (String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readMessage(ObjectValue clientConnector, String folder) {
        String host = (String)clientConnector.getNativeData("host");
        String username = (String)clientConnector.getNativeData("username");
        String password = (String)clientConnector.getNativeData("password");
        try (Store store = (Store)clientConnector.getNativeData("store");){
            store.connect(host, username, password);
            Folder emailFolder = store.getFolder(folder);
            emailFolder.open(2);
            Message[] messages = emailFolder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
            MapValue mapValue2 = null;
            if (messages.length > 0) {
                Flags flags = new Flags();
                flags.add(Flags.Flag.SEEN);
                emailFolder.setFlags(new int[]{messages[0].getMessageNumber()}, flags, true);
                mapValue2 = EmailAccessUtil.getMapValue(messages[0]);
            }
            if (log.isDebugEnabled()) {
                log.debug("[EmailAccessClient][Read] Got the messages. Email count = " + messages.length);
            }
            emailFolder.close(false);
            MapValue mapValue = mapValue2;
            return mapValue;
        }
        catch (IOException | MessagingException e) {
            log.error("Failed to read message : ", e);
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)"{ballerina/email}ReadError"), (String)e.getMessage());
        }
    }
}

