/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.email.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.ballerinalang.jvm.values.MapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);

    protected static boolean isTextBased(String contentType) {
        return contentType.startsWith("text/") || contentType.endsWith("+xml") || contentType.endsWith("+json") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/x-www-form-urlencoded");
    }

    protected static boolean isJsonBased(String contentType) {
        return contentType.contains("json");
    }

    protected static boolean isXmlBased(String contentType) {
        return contentType.contains("xml");
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static void addCustomProperties(MapValue customProperties, Properties properties) {
        if (customProperties != null) {
            for (Object propertyName : customProperties.getKeys()) {
                if (!(propertyName instanceof String)) continue;
                properties.put(propertyName, customProperties.getStringValue((String)propertyName));
                log.debug("Added custom SMTP property with Name: " + propertyName + ", Value: " + customProperties.getStringValue((String)propertyName));
            }
        }
    }
}

