/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.email.util;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.pop3.POP3Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeConstants;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.stdlib.email.util.CommonUtil;
import org.ballerinalang.stdlib.email.util.EmailConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAccessUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailAccessUtil.class);
    private static final BArrayType stringArrayType = new BArrayType(BTypes.typeString);

    public static Properties getPopProperties(MapValue emailAccessConfig, String host) {
        Properties properties = new Properties();
        properties.put("mail.pop3.host", host);
        properties.put("mail.pop3.port", Long.toString(emailAccessConfig.getIntValue("port")));
        properties.put("mail.pop.auth", "true");
        properties.put("mail.pop3.starttls.enable", "true");
        properties.put("mail.pop3.ssl.enable", emailAccessConfig.getBooleanValue("enableSsl"));
        properties.put("mail.store.protocol", "pop3");
        return properties;
    }

    public static Properties getImapProperties(MapValue emailAccessConfig, String host) {
        Properties properties = new Properties();
        properties.put("mail.imap.host", host);
        properties.put("mail.imap.port", Long.toString(emailAccessConfig.getIntValue("port")));
        properties.put("mail.imap.auth", "true");
        properties.put("mail.imap.starttls.enable", "true");
        properties.put("mail.imap.ssl.enable", emailAccessConfig.getBooleanValue("enableSsl"));
        properties.put("mail.store.protocol", "imap");
        return properties;
    }

    public static MapValue getMapValue(Message message) throws MessagingException, IOException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        BArray toAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getRecipients(Message.RecipientType.TO));
        BArray ccAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getRecipients(Message.RecipientType.CC));
        BArray bccAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getRecipients(Message.RecipientType.BCC));
        BArray replyToAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getReplyTo());
        String subject = EmailAccessUtil.getStringNullChecked(message.getSubject());
        String messageBody = EmailAccessUtil.extractBodyFromMessage(message);
        String fromAddress = EmailAccessUtil.extractFromAddressFromMessage(message);
        String senderAddress = EmailAccessUtil.getSenderAddress(message);
        BArray attachments = EmailAccessUtil.extractAttachmentsFromMessage(message);
        valueMap.put("to", toAddressArrayValue);
        valueMap.put("cc", ccAddressArrayValue);
        valueMap.put("bcc", bccAddressArrayValue);
        valueMap.put("replyTo", replyToAddressArrayValue);
        valueMap.put("subject", subject);
        valueMap.put("body", messageBody);
        valueMap.put("from", fromAddress);
        valueMap.put("sender", senderAddress);
        if (attachments != null && attachments.size() > 0) {
            valueMap.put("attachments", attachments);
        }
        return BallerinaValues.createRecordValue((BPackage)EmailConstants.EMAIL_PACKAGE_ID, (String)"Email", valueMap);
    }

    private static String extractBodyFromMessage(Message message) throws MessagingException, IOException {
        MimeMultipart mimeMultipart;
        String messageBody = "";
        if (message.getContentType() != null && CommonUtil.isTextBased(message.getContentType())) {
            if (message.getContent() != null) {
                messageBody = message.getContent().toString();
            }
        } else if (message.isMimeType("multipart/*") && (mimeMultipart = (MimeMultipart)message.getContent()) != null && mimeMultipart.getCount() > 0 && mimeMultipart.getBodyPart(0) != null && mimeMultipart.getBodyPart(0).getContent() != null) {
            messageBody = (String)mimeMultipart.getBodyPart(0).getContent();
        }
        return messageBody;
    }

    private static BArray extractAttachmentsFromMessage(Message message) throws MessagingException, IOException {
        ArrayList<ObjectValue> attachmentArray = new ArrayList<ObjectValue>();
        if (!message.isMimeType("multipart/*")) {
            return null;
        }
        MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
        int numberOfAttachments = mimeMultipart.getCount();
        if (numberOfAttachments > 1) {
            for (int i = 1; i < numberOfAttachments; ++i) {
                EmailAccessUtil.attachMultipart(mimeMultipart.getBodyPart(i), attachmentArray);
            }
            return EmailAccessUtil.getArrayOfEntities(attachmentArray);
        }
        log.debug("Received a Multipart email message without any attachments.");
        return null;
    }

    private static void attachMultipart(BodyPart bodyPart, ArrayList<ObjectValue> entityArray) throws MessagingException, IOException {
        if (bodyPart.isMimeType("multipart/*")) {
            entityArray.add(EmailAccessUtil.getMultipartEntity(bodyPart));
        } else {
            String contentType = bodyPart.getContentType();
            if (contentType != null && bodyPart.getContent() instanceof String) {
                if (CommonUtil.isJsonBased(contentType)) {
                    entityArray.add(EmailAccessUtil.getJsonEntity(bodyPart));
                } else if (CommonUtil.isXmlBased(contentType)) {
                    entityArray.add(EmailAccessUtil.getXmlEntity(bodyPart));
                } else {
                    entityArray.add(EmailAccessUtil.getTextEntity(bodyPart));
                }
            } else {
                entityArray.add(EmailAccessUtil.getBinaryEntity(bodyPart));
            }
        }
    }

    private static ObjectValue getMultipartEntity(BodyPart bodyPart) throws MessagingException, IOException {
        ObjectValue multipartEntity = EmailAccessUtil.createEntityObject();
        ArrayList<ObjectValue> entities = EmailAccessUtil.getMultipleEntities(bodyPart);
        if (entities != null && bodyPart.getContentType() != null) {
            multipartEntity.addNativeData("body_parts", (Object)EmailAccessUtil.getArrayOfEntities(entities));
            MimeUtil.setContentType((ObjectValue)EmailAccessUtil.createMediaTypeObject(), (ObjectValue)multipartEntity, (String)bodyPart.getContentType());
            EmailAccessUtil.setEntityHeaders(multipartEntity, bodyPart);
        }
        return multipartEntity;
    }

    private static ArrayList<ObjectValue> getMultipleEntities(BodyPart bodyPart) throws IOException, MessagingException {
        ArrayList<ObjectValue> entityArray = new ArrayList<ObjectValue>();
        MimeMultipart mimeMultipart = (MimeMultipart)bodyPart.getContent();
        int numberOfBodyParts = mimeMultipart.getCount();
        if (numberOfBodyParts > 0) {
            for (int i = 0; i < numberOfBodyParts; ++i) {
                EmailAccessUtil.attachMultipart(bodyPart, entityArray);
            }
            return entityArray;
        }
        return null;
    }

    private static ObjectValue getJsonEntity(BodyPart bodyPart) throws IOException, MessagingException {
        String jsonContent = (String)bodyPart.getContent();
        ObjectValue entity = EmailAccessUtil.createEntityObject();
        EntityWrapper byteChannel = EntityBodyHandler.getEntityWrapper((String)jsonContent);
        entity.addNativeData("entity_byte_channel", (Object)byteChannel);
        MimeUtil.setContentType((ObjectValue)EmailAccessUtil.createMediaTypeObject(), (ObjectValue)entity, (String)"application/json");
        EmailAccessUtil.setEntityHeaders(entity, bodyPart);
        return entity;
    }

    private static ObjectValue getXmlEntity(BodyPart bodyPart) throws IOException, MessagingException {
        String xmlContent = (String)bodyPart.getContent();
        XMLValue xmlNode = XMLFactory.parse((String)xmlContent);
        ObjectValue entity = EmailAccessUtil.createEntityObject();
        EntityBodyChannel byteChannel = new EntityBodyChannel((InputStream)new ByteArrayInputStream(xmlNode.stringValue().getBytes(StandardCharsets.UTF_8)));
        entity.addNativeData("entity_byte_channel", (Object)new EntityWrapper(byteChannel));
        MimeUtil.setContentType((ObjectValue)EmailAccessUtil.createMediaTypeObject(), (ObjectValue)entity, (String)"application/xml");
        EmailAccessUtil.setEntityHeaders(entity, bodyPart);
        return entity;
    }

    private static ObjectValue getTextEntity(BodyPart bodyPart) throws IOException, MessagingException {
        String textPayload = (String)bodyPart.getContent();
        ObjectValue entity = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"Entity", (Object[])new Object[0]);
        entity.addNativeData("entity_byte_channel", (Object)EntityBodyHandler.getEntityWrapper((String)textPayload));
        MimeUtil.setContentType((ObjectValue)EmailAccessUtil.createMediaTypeObject(), (ObjectValue)entity, (String)"text/plain");
        EmailAccessUtil.setEntityHeaders(entity, bodyPart);
        return entity;
    }

    private static ObjectValue getBinaryEntity(BodyPart bodyPart) throws IOException, MessagingException {
        byte[] binaryContent = CommonUtil.convertInputStreamToByteArray(bodyPart.getInputStream());
        EntityWrapper byteChannel = new EntityWrapper(new EntityBodyChannel((InputStream)new ByteArrayInputStream(binaryContent)));
        ObjectValue entity = EmailAccessUtil.createEntityObject();
        entity.addNativeData("entity_byte_channel", (Object)byteChannel);
        MimeUtil.setContentType((ObjectValue)EmailAccessUtil.createMediaTypeObject(), (ObjectValue)entity, (String)"application/octet-stream");
        EmailAccessUtil.setEntityHeaders(entity, bodyPart);
        return entity;
    }

    private static void setEntityHeaders(ObjectValue entity, BodyPart bodyPart) throws MessagingException {
        Enumeration headers = bodyPart.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            HeaderUtil.setHeaderToEntity((ObjectValue)entity, (String)header.getName(), (String)header.getValue());
        }
    }

    private static ArrayValue getArrayOfEntities(ArrayList<ObjectValue> entities) {
        BObjectType typeOfEntity = entities.get(0).getType();
        Object[] result = entities.toArray(new ObjectValue[entities.size()]);
        return new ArrayValueImpl(result, new BArrayType((BType)typeOfEntity));
    }

    private static ObjectValue createMediaTypeObject() {
        return BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"MediaType", (Object[])new Object[0]);
    }

    private static ObjectValue createEntityObject() {
        return BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"Entity", (Object[])new Object[0]);
    }

    private static String extractFromAddressFromMessage(Message message) throws MessagingException {
        String fromAddress = "";
        if (message.getFrom() != null) {
            fromAddress = message.getFrom()[0].toString();
        }
        return fromAddress;
    }

    private static String getSenderAddress(Message message) throws MessagingException {
        String senderAddress = "";
        if (message instanceof POP3Message) {
            if (((POP3Message)message).getSender() != null) {
                senderAddress = ((POP3Message)message).getSender().toString();
            }
        } else if (message instanceof IMAPMessage && ((IMAPMessage)message).getSender() != null) {
            senderAddress = ((IMAPMessage)message).getSender().toString();
        }
        return senderAddress;
    }

    private static BArray getAddressBArrayList(Address[] addresses) {
        BArray addressArrayValue = BValueCreator.createArrayValue((BArrayType)stringArrayType);
        if (addresses != null) {
            for (Address address : addresses) {
                addressArrayValue.append((Object)address.toString());
            }
        }
        return addressArrayValue;
    }

    private static String getStringNullChecked(String string) {
        return string == null ? "" : string;
    }
}

