/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.time.Duration;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.observe.nativeimpl.Utils;

@BallerinaFunction(orgName="ballerina", packageName="observe", functionName="initialize", receiver=@Receiver(type=TypeKind.OBJECT, structType="Gauge", structPackage="ballerina/observe"))
public class GaugeInitialize {
    public static void initialize(Strand strand, ObjectValue guage) {
        ArrayValue summaryConfigs = (ArrayValue)guage.get("statisticConfigs");
        Gauge.Builder gaugeBuilder = Gauge.builder((String)((String)guage.get("name"))).description((String)guage.get("description")).tags(Utils.toStringMap((MapValue)guage.get("metricTags")));
        if (summaryConfigs != null && summaryConfigs.size() > 0) {
            for (int i = 0; i < summaryConfigs.size(); ++i) {
                MapValue summaryConfigStruct = (MapValue)summaryConfigs.get((long)i);
                StatisticConfig.Builder statisticBuilder = StatisticConfig.builder().expiry(Duration.ofMillis((Long)summaryConfigStruct.get((Object)"timeWindow"))).buckets(((Long)summaryConfigStruct.get((Object)"buckets")).longValue());
                ArrayValue bFloatArray = (ArrayValue)summaryConfigStruct.get((Object)"percentiles");
                double[] percentiles = new double[bFloatArray.size()];
                for (int j = 0; j < bFloatArray.size(); ++j) {
                    percentiles[j] = bFloatArray.getFloat((long)j);
                }
                statisticBuilder.percentiles(percentiles);
                StatisticConfig config = statisticBuilder.build();
                gaugeBuilder.summarize(config);
            }
        }
        Gauge gauge = gaugeBuilder.build();
        guage.addNativeData("__metric_native_instance__", (Object)gauge);
    }
}

