/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.metrics.PercentileValue;
import org.ballerinalang.jvm.observability.metrics.Snapshot;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.observe.nativeimpl.ObserveNativeImplConstants;

public class Utils {
    private static final BType STATISTIC_CONFIG_TYPE = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"StatisticConfig").getType();
    private static final BType PERCENTILE_VALUE_TYPE = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"PercentileValue").getType();
    private static final BType SNAPSHOT_TYPE = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Snapshot").getType();

    public static Map<String, String> toStringMap(MapValue<?, ?> map) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (map != null) {
            for (Map.Entry keyVals : map.entrySet()) {
                Object value = keyVals.getValue();
                returnMap.put(keyVals.getKey().toString(), value == null ? "()" : value.toString());
            }
        }
        return returnMap;
    }

    public static ArrayValue createBSnapshots(Snapshot[] snapshots, Strand strand) {
        if (snapshots != null && snapshots.length > 0) {
            ArrayValueImpl bSnapshots = new ArrayValueImpl(new BArrayType(SNAPSHOT_TYPE));
            int index = 0;
            for (Snapshot snapshot : snapshots) {
                ArrayValueImpl bPercentiles = new ArrayValueImpl(new BArrayType(PERCENTILE_VALUE_TYPE));
                int percentileIndex = 0;
                for (PercentileValue percentileValue : snapshot.getPercentileValues()) {
                    MapValue bPercentileValue = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"PercentileValue");
                    bPercentileValue.put((Object)"percentile", (Object)percentileValue.getPercentile());
                    bPercentileValue.put((Object)"value", (Object)percentileValue.getValue());
                    bPercentiles.add((long)percentileIndex, (Object)bPercentileValue);
                    ++percentileIndex;
                }
                MapValue aSnapshot = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Snapshot");
                aSnapshot.put((Object)"timeWindow", (Object)snapshot.getTimeWindow().toMillis());
                aSnapshot.put((Object)"mean", (Object)snapshot.getMean());
                aSnapshot.put((Object)"max", (Object)snapshot.getMax());
                aSnapshot.put((Object)"min", (Object)snapshot.getMin());
                aSnapshot.put((Object)"stdDev", (Object)snapshot.getStdDev());
                aSnapshot.put((Object)"percentileValues", (Object)bPercentiles);
                bSnapshots.add((long)index, (Object)aSnapshot);
                ++index;
            }
            return bSnapshots;
        }
        return null;
    }

    public static ArrayValue createBStatisticConfig(StatisticConfig[] configs) {
        if (configs != null) {
            ArrayValueImpl bStatsConfig = new ArrayValueImpl(new BArrayType(STATISTIC_CONFIG_TYPE));
            int index = 0;
            for (StatisticConfig config : configs) {
                ArrayValueImpl bPercentiles = new ArrayValueImpl(new BArrayType(BTypes.typeFloat));
                int percentileIndex = 0;
                double[] dArray = config.getPercentiles();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double percentile = dArray[i];
                    bPercentiles.add((long)percentileIndex, (Object)percentile);
                    ++percentileIndex;
                }
                MapValue aSnapshot = BallerinaValues.createRecordValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"StatisticConfig");
                aSnapshot.put((Object)"percentiles", (Object)bPercentiles);
                aSnapshot.put((Object)"timeWindow", (Object)config.getTimeWindow());
                aSnapshot.put((Object)"buckets", (Object)config.getBuckets());
                bStatsConfig.add((long)index, (Object)aSnapshot);
                ++index;
            }
            return bStatsConfig;
        }
        return new ArrayValueImpl(new BArrayType(STATISTIC_CONFIG_TYPE));
    }
}

