/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.internal;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.internal.IsElement;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.__internal", functionName="getAttribute", args={@Argument(name="xmlValue", type=TypeKind.XML), @Argument(name="attrName", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.UNION)}, isPublic=true)
public class GetAttribute {
    public static Object getAttribute(Strand strand, XMLValue xmlVal, String attrName, boolean optionalFiledAccess) {
        if (xmlVal.getNodeType() == XMLNodeType.SEQUENCE && ((XMLSequence)xmlVal).size() == 0) {
            return null;
        }
        if (!IsElement.isElement(xmlVal)) {
            return BallerinaErrors.createError((String)BallerinaErrorReasons.XML_OPERATION_ERROR, (String)("Invalid xml attribute access on xml " + xmlVal.getNodeType().value()));
        }
        XMLQName qname = new XMLQName(attrName);
        String attrVal = xmlVal.getAttribute(qname.getLocalName(), qname.getUri());
        if (attrVal == null && !optionalFiledAccess) {
            return BallerinaErrors.createError((String)BallerinaErrorReasons.XML_OPERATION_ERROR, (String)("attribute '" + attrName + "' not found"));
        }
        return attrVal;
    }
}

