/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import java.net.URI;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpDispatcher;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.websub.WebSubResourceDispatcher;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

class WebSubDispatcher {
    static HttpResource findResource(WebSubServicesRegistry servicesRegistry, HttpCarbonMessage inboundMessage) {
        String protocol = (String)inboundMessage.getProperty("PROTOCOL");
        if (protocol == null) {
            throw new BallerinaConnectorException("protocol not defined in the incoming request");
        }
        try {
            HttpService service = HttpDispatcher.findService((HTTPServicesRegistry)servicesRegistry, (HttpCarbonMessage)inboundMessage);
            if (service == null) {
                throw new BallerinaConnectorException("no service found to handle the service request");
            }
            URI validatedUri = HttpDispatcher.getValidatedURI((String)((String)inboundMessage.getProperty("TO")));
            if (!validatedUri.getPath().equals(service.getBasePath())) {
                throw new BallerinaConnectorException("no matching service found for path : " + validatedUri.getRawPath());
            }
            return WebSubResourceDispatcher.findResource(service, inboundMessage, servicesRegistry);
        }
        catch (Exception e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
    }

    private WebSubDispatcher() {
    }
}

