/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import java.util.List;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.websub.BallerinaWebSubException;
import org.ballerinalang.net.websub.WebSubSubscriberConstants;
import org.ballerinalang.net.websub.WebSubUtils;
import org.ballerinalang.net.websub.hub.Hub;
import org.ballerinalang.net.websub.hub.HubSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubNativeOperationHandler {
    private static final Logger log = LoggerFactory.getLogger(HubNativeOperationHandler.class);

    public static ArrayValue getAvailableTopics(ObjectValue webSubHub) {
        String[] topics = Hub.getInstance().getTopics();
        return new ArrayValueImpl(topics);
    }

    public static ArrayValue getSubscribers(ObjectValue webSubHub, String topic) {
        ArrayValueImpl subscriberDetailArray = null;
        try {
            List<HubSubscriber> subscribers = Hub.getInstance().getSubscribers();
            MapValue subscriberDetailsRecordValue = BallerinaValues.createRecordValue((BPackage)WebSubSubscriberConstants.WEBSUB_PACKAGE_ID, (String)"SubscriberDetails");
            subscriberDetailArray = new ArrayValueImpl(new BArrayType(subscriberDetailsRecordValue.getType()));
            for (HubSubscriber subscriber : subscribers) {
                if (!topic.equals(subscriber.getTopic())) continue;
                MapValue subscriberDetail = BallerinaValues.createRecord((MapValue)subscriberDetailsRecordValue, (Object[])new Object[]{subscriber.getCallback(), subscriber.getSubscriptionDetails().get((Object)"leaseSeconds"), subscriber.getSubscriptionDetails().get((Object)"createdAt")});
                subscriberDetailArray.append((Object)subscriberDetail);
            }
        }
        catch (Exception ex) {
            log.error("Error occurred while getting available subscribers.", (Throwable)ex);
        }
        return subscriberDetailArray;
    }

    public static Object startUpHubService(String basePath, String subscriptionResourcePath, String publishResourcePath, boolean topicRegistrationRequired, String publicUrl, ObjectValue hubListener) {
        Hub hubInstance = Hub.getInstance();
        if (hubInstance.isStarted()) {
            MapValue hubStartedUpError = BallerinaValues.createRecordValue((BPackage)WebSubSubscriberConstants.WEBSUB_PACKAGE_ID, (String)"HubStartedUpError");
            return BallerinaValues.createRecord((MapValue)hubStartedUpError, (Object[])new Object[]{"Ballerina Hub already started up", null, hubInstance.getHubObject()});
        }
        return hubInstance.startUpHubService(Scheduler.getStrand(), basePath, subscriptionResourcePath, publishResourcePath, topicRegistrationRequired, publicUrl, hubListener);
    }

    public static Object stopHubService(ObjectValue hub) {
        Hub hubInstance = Hub.getInstance();
        if (hubInstance.isStarted()) {
            try {
                if (hubInstance.getHubObject() != hub) {
                    return WebSubUtils.createError("error stopping the hub service: hub object does not match the started hub");
                }
                hubInstance.stopHubService();
                return null;
            }
            catch (BallerinaWebSubException e) {
                return WebSubUtils.createError(e.getMessage());
            }
        }
        return WebSubUtils.createError("error stopping the hub service: hub service not started");
    }

    public static void addSubscription(MapValue<String, Object> subscriptionDetails) {
        String topic = subscriptionDetails.getStringValue("topic");
        String callback = subscriptionDetails.getStringValue("callback");
        Hub.getInstance().registerSubscription(Scheduler.getStrand(), topic, callback, subscriptionDetails);
    }

    public static Object publishToInternalHub(String topic, MapValue<String, Object> content) {
        try {
            Hub.getInstance().publish(topic, content);
        }
        catch (BallerinaWebSubException e) {
            return WebSubUtils.createError(e.getMessage());
        }
        return null;
    }

    public static void removeNativeSubscription(String topic, String callback) {
        Hub.getInstance().unregisterSubscription(Scheduler.getStrand(), topic, callback);
    }

    public static Object registerTopicAtNativeHub(String topic) {
        try {
            Hub.getInstance().registerTopic(topic);
        }
        catch (BallerinaWebSubException e) {
            return WebSubUtils.createError(e.getMessage());
        }
        return null;
    }

    public static Object unregisterTopicAtNativeHub(String topic) {
        try {
            Hub.getInstance().unregisterTopic(topic);
        }
        catch (BallerinaWebSubException e) {
            return WebSubUtils.createError(e.getMessage());
        }
        return null;
    }

    public static boolean isTopicRegistered(String topic) {
        return Hub.getInstance().isTopicRegistered(topic);
    }
}

