/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import java.util.HashMap;
import java.util.Optional;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.net.http.HttpConnectorPortBindingListener;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.websocket.server.WebSocketServicesRegistry;
import org.ballerinalang.net.websub.BallerinaWebSubConnectorListener;
import org.ballerinalang.net.websub.WebSubHttpService;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.ballerinalang.net.websub.WebSubUtils;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;

public class SubscriberNativeOperationHandler {
    private static final BArrayType mapArrayType = new BArrayType((BType)new BMapType(BTypes.typeAny));

    public static void initWebSubSubscriberServiceEndpoint(ObjectValue subscriberServiceListener) {
        WebSubServicesRegistry webSubServicesRegistry;
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceListener.get("serviceEndpoint");
        MapValue config = (MapValue)subscriberServiceListener.get("config");
        if (config == null || config.get((Object)"extensionConfig") == null) {
            webSubServicesRegistry = new WebSubServicesRegistry(new WebSocketServicesRegistry());
        } else {
            MapValue extensionConfig = (MapValue)config.get((Object)"extensionConfig");
            String topicIdentifier = extensionConfig.getStringValue("topicIdentifier");
            String topicHeader = null;
            MapValue headerResourceMap = null;
            MapValue payloadKeyResourceMap = null;
            MapValue headerAndPayloadKeyResourceMap = null;
            if (("TOPIC_ID_HEADER".equals(topicIdentifier) || "TOPIC_ID_HEADER_AND_PAYLOAD".equals(topicIdentifier)) && (topicHeader = extensionConfig.getStringValue("topicHeader")) == null) {
                throw new BallerinaConnectorException("Topic Header not specified to dispatch by " + topicIdentifier);
            }
            if ("TOPIC_ID_HEADER".equals(topicIdentifier)) {
                headerResourceMap = (MapValue)extensionConfig.get((Object)"headerResourceMap");
                if (headerResourceMap == null) {
                    throw new BallerinaConnectorException("Resource map not specified to dispatch by header");
                }
            } else if ("TOPIC_ID_HEADER_AND_PAYLOAD".equals(topicIdentifier)) {
                headerAndPayloadKeyResourceMap = (MapValue)extensionConfig.get((Object)"headerAndPayloadKeyResourceMap");
                if (headerAndPayloadKeyResourceMap == null) {
                    throw new BallerinaConnectorException("Resource map not specified to dispatch by header and payload");
                }
                headerResourceMap = (MapValue)extensionConfig.get((Object)"headerResourceMap");
                payloadKeyResourceMap = (MapValue)extensionConfig.get((Object)"payloadKeyResourceMap");
            } else {
                payloadKeyResourceMap = (MapValue)extensionConfig.get((Object)"payloadKeyResourceMap");
                if (payloadKeyResourceMap == null) {
                    throw new BallerinaConnectorException("Resource map not specified to dispatch by payload");
                }
            }
            HashMap<String, BRecordType> resourceDetails = SubscriberNativeOperationHandler.buildResourceDetailsMap(topicIdentifier, (MapValue<String, Object>)headerResourceMap, (MapValue<String, MapValue<String, Object>>)payloadKeyResourceMap, (MapValue<String, MapValue<String, MapValue<String, Object>>>)headerAndPayloadKeyResourceMap);
            webSubServicesRegistry = new WebSubServicesRegistry(new WebSocketServicesRegistry(), topicIdentifier, topicHeader, (MapValue<String, Object>)headerResourceMap, (MapValue<String, MapValue<String, Object>>)payloadKeyResourceMap, (MapValue<String, MapValue<String, MapValue<String, Object>>>)headerAndPayloadKeyResourceMap, resourceDetails);
        }
        serviceEndpoint.addNativeData("WEBSUB_SERVICE_REGISTRY", (Object)webSubServicesRegistry);
    }

    private static HashMap<String, BRecordType> buildResourceDetailsMap(String topicIdentifier, MapValue<String, Object> headerResourceMap, MapValue<String, MapValue<String, Object>> payloadKeyResourceMap, MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap) {
        HashMap<String, BRecordType> resourceDetails = new HashMap<String, BRecordType>();
        if (topicIdentifier != null) {
            switch (topicIdentifier) {
                case "TOPIC_ID_HEADER": {
                    SubscriberNativeOperationHandler.populateResourceDetailsByHeader(headerResourceMap, resourceDetails);
                    break;
                }
                case "TOPIC_ID_PAYLOAD_KEY": {
                    SubscriberNativeOperationHandler.populateResourceDetailsByPayload(payloadKeyResourceMap, resourceDetails);
                    break;
                }
                default: {
                    SubscriberNativeOperationHandler.populateResourceDetailsByHeaderAndPayload(headerAndPayloadKeyResourceMap, resourceDetails);
                    if (headerResourceMap != null) {
                        SubscriberNativeOperationHandler.populateResourceDetailsByHeader(headerResourceMap, resourceDetails);
                    }
                    if (payloadKeyResourceMap == null) break;
                    SubscriberNativeOperationHandler.populateResourceDetailsByPayload(payloadKeyResourceMap, resourceDetails);
                }
            }
        }
        return resourceDetails;
    }

    private static void populateResourceDetailsByHeader(MapValue<String, Object> headerResourceMap, HashMap<String, BRecordType> resourceDetails) {
        headerResourceMap.values().forEach(value -> SubscriberNativeOperationHandler.populateResourceDetails(resourceDetails, (ArrayValue)value));
    }

    private static void populateResourceDetailsByPayload(MapValue<String, MapValue<String, Object>> payloadKeyResourceMap, HashMap<String, BRecordType> resourceDetails) {
        payloadKeyResourceMap.values().forEach(mapByKey -> mapByKey.values().forEach(value -> SubscriberNativeOperationHandler.populateResourceDetails(resourceDetails, (ArrayValue)value)));
    }

    private static void populateResourceDetailsByHeaderAndPayload(MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap, HashMap<String, BRecordType> resourceDetails) {
        headerAndPayloadKeyResourceMap.values().forEach(mapByHeader -> mapByHeader.values().forEach(mapByKey -> mapByKey.values().forEach(value -> SubscriberNativeOperationHandler.populateResourceDetails(resourceDetails, (ArrayValue)value))));
    }

    private static void populateResourceDetails(HashMap<String, BRecordType> resourceDetails, ArrayValue resourceDetailTuple) {
        String resourceName = resourceDetailTuple.getRefValue(0L).toString();
        resourceDetails.put(resourceName, (BRecordType)((TypedescValue)resourceDetailTuple.getRefValue(1L)).getDescribingType());
    }

    public static void registerWebSubSubscriberService(ObjectValue subscriberServiceListener, ObjectValue service) {
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceListener.get("serviceEndpoint");
        WebSubServicesRegistry webSubServicesRegistry = (WebSubServicesRegistry)((Object)serviceEndpoint.getNativeData("WEBSUB_SERVICE_REGISTRY"));
        webSubServicesRegistry.registerWebSubSubscriberService(service);
    }

    public static Object startWebSubSubscriberServiceEndpoint(ObjectValue subscriberServiceListener) {
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceListener.get("serviceEndpoint");
        ServerConnector serverConnector = (ServerConnector)serviceEndpoint.getNativeData("HTTP_SERVER_CONNECTOR");
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        WebSubServicesRegistry webSubServicesRegistry = (WebSubServicesRegistry)((Object)serviceEndpoint.getNativeData("WEBSUB_SERVICE_REGISTRY"));
        serverConnectorFuture.setHttpConnectorListener((HttpConnectorListener)new BallerinaWebSubConnectorListener(Scheduler.getStrand(), webSubServicesRegistry, serviceEndpoint.getMapValue("config")));
        serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)new HttpConnectorPortBindingListener());
        try {
            serverConnectorFuture.sync();
        }
        catch (Exception ex) {
            return WebSubUtils.createError("{ballerina/websub}ListenerStartupError", "failed to start server connector '" + serverConnector.getConnectorID() + "': " + ex.getMessage());
        }
        return null;
    }

    public static void setTopic(ObjectValue subscriberServiceListener, String webSubServiceName, String topic) {
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceListener.get("serviceEndpoint");
        WebSubServicesRegistry webSubServicesRegistry = (WebSubServicesRegistry)((Object)serviceEndpoint.getNativeData("WEBSUB_SERVICE_REGISTRY"));
        if (webSubServicesRegistry.getServicesMapHolder("b7a.default") == null) {
            return;
        }
        Optional<HttpService> webSubHttpService = webSubServicesRegistry.getServicesByHost("b7a.default").values().stream().filter(httpService -> webSubServiceName.equals(httpService.getBalService().getType().getName())).findFirst();
        HttpService httpService2 = webSubHttpService.orElse(null);
        if (httpService2 instanceof WebSubHttpService) {
            ((WebSubHttpService)httpService2).setTopic(topic);
        }
    }

    public static ArrayValue retrieveSubscriptionParameters(ObjectValue subscriberServiceListener) {
        ArrayValue subscriptionDetailArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)mapArrayType);
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceListener.get("serviceEndpoint");
        WebSubServicesRegistry webSubServicesRegistry = (WebSubServicesRegistry)((Object)serviceEndpoint.getNativeData("WEBSUB_SERVICE_REGISTRY"));
        if (webSubServicesRegistry.getServicesMapHolder("b7a.default") == null) {
            return subscriptionDetailArray;
        }
        Object[] webSubHttpServices = webSubServicesRegistry.getServicesByHost("b7a.default").values().toArray();
        for (int index = 0; index < webSubHttpServices.length; ++index) {
            String callback;
            WebSubHttpService webSubHttpService = (WebSubHttpService)((Object)webSubHttpServices[index]);
            MapValueImpl subscriptionDetails = new MapValueImpl();
            MapValue annotation = (MapValue)webSubHttpService.getBalService().getType().getAnnotation("ballerina/websub", "SubscriberServiceConfig");
            subscriptionDetails.put((Object)"webSubServiceName", (Object)webSubHttpService.getBalService().getType().getName());
            subscriptionDetails.put((Object)"subscribeOnStartUp", (Object)annotation.getBooleanValue("subscribeOnStartUp"));
            if (annotation.containsKey((Object)"target")) {
                subscriptionDetails.put((Object)"target", annotation.get((Object)"target"));
            }
            if (annotation.containsKey((Object)"leaseSeconds")) {
                subscriptionDetails.put((Object)"leaseSeconds", (Object)annotation.getIntValue("leaseSeconds"));
            }
            if (annotation.containsKey((Object)"secret")) {
                subscriptionDetails.put((Object)"secret", (Object)annotation.getStringValue("secret"));
            }
            subscriptionDetails.put((Object)"expectIntentVerification", (Object)annotation.getBooleanValue("expectIntentVerification"));
            if (annotation.containsKey((Object)"publisherClientConfig")) {
                MapValue publisherClientConfig = (MapValue)annotation.get((Object)"publisherClientConfig");
                subscriptionDetails.put((Object)"publisherClientConfig", (Object)publisherClientConfig);
            }
            if (annotation.containsKey((Object)"hubClientConfig")) {
                MapValue hubClientConfig = (MapValue)annotation.get((Object)"hubClientConfig");
                subscriptionDetails.put((Object)"hubClientConfig", (Object)hubClientConfig);
            }
            if (annotation.containsKey((Object)"callback")) {
                callback = annotation.getStringValue("callback");
            } else {
                callback = webSubHttpService.getBasePath();
                MapValue serviceEndpointConfig = (MapValue)serviceEndpoint.get("config");
                long port = serviceEndpoint.getIntValue("port");
                callback = !serviceEndpointConfig.getStringValue("host").isEmpty() && port != 0L ? serviceEndpointConfig.getStringValue("host") + ":" + port + callback : ((ServerConnector)serviceEndpoint.getNativeData("HTTP_SERVER_CONNECTOR")).getConnectorID() + callback;
                if (callback.startsWith("0.0.0.0")) {
                    callback = callback.replace("0.0.0.0", "localhost");
                }
                if (!callback.contains("://")) {
                    callback = serviceEndpointConfig.get((Object)"secureSocket") != null ? "https://".concat(callback) : "http://".concat(callback);
                }
            }
            subscriptionDetails.put((Object)"callback", (Object)callback);
            subscriptionDetailArray.add((long)index, (Object)subscriptionDetails);
        }
        return subscriptionDetailArray;
    }
}

