/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.client.generator.model;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.client.generator.exception.ClientGeneratorException;
import org.ballerinalang.client.generator.model.EndpointContextHolder;
import org.ballerinalang.client.generator.model.ResourceContextHolder;
import org.ballerinalang.model.tree.FunctionNode;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public class ClientContextHolder {
    private String name;
    private List<ResourceContextHolder> resources;
    private List<EndpointContextHolder> endpoints;

    public static ClientContextHolder buildContext(BLangService service, List<BLangSimpleVariable> endpoints) throws ClientGeneratorException {
        ClientContextHolder context = new ClientContextHolder();
        context.name = service.getName().getValue();
        context.resources = new ArrayList<ResourceContextHolder>();
        context.endpoints = new ArrayList<EndpointContextHolder>();
        for (BLangSimpleVariable ep : endpoints) {
            EndpointContextHolder epContext = EndpointContextHolder.buildContext(service, ep);
            if (epContext == null) continue;
            context.endpoints.add(epContext);
        }
        for (FunctionNode resource : service.getResources()) {
            ResourceContextHolder operation = ResourceContextHolder.buildContext(resource);
            context.resources.add(operation);
        }
        return context;
    }

    public String getName() {
        return this.name;
    }

    public List<ResourceContextHolder> getResources() {
        return this.resources;
    }

    public List<EndpointContextHolder> getEndpoints() {
        return this.endpoints;
    }
}

