/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.client.generator.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ballerinalang.client.generator.exception.ClientGeneratorException;
import org.ballerinalang.client.generator.model.ParameterContextHolder;
import org.ballerinalang.client.generator.util.GeneratorUtils;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class ResourceContextHolder {
    private String method;
    private String name;
    private String contentType;
    private List<ParameterContextHolder> parameters;
    private boolean isMultiMethod;
    private List<String> supportedMethods;
    private String path;

    public static ResourceContextHolder buildContext(FunctionNode resource) throws ClientGeneratorException {
        ResourceContextHolder context = new ResourceContextHolder();
        context.name = resource.getName().getValue();
        context.parameters = new ArrayList<ParameterContextHolder>();
        for (SimpleVariableNode node : resource.getParameters()) {
            ParameterContextHolder parameter = ParameterContextHolder.buildContext(node);
            if (parameter == null) continue;
            context.parameters.add(parameter);
        }
        AnnotationAttachmentNode ann = GeneratorUtils.getAnnotationFromList("ResourceConfig", "http", resource.getAnnotationAttachments());
        if (ann == null) {
            throw new ClientGeneratorException("Incomplete resource configuration found");
        }
        Map<String, String[]> attrs = GeneratorUtils.getKeyValuePairAsMap(((BLangRecordLiteral)((BLangAnnotationAttachment)ann).getExpression()).getFields());
        if (attrs.get("methods") != null) {
            if (attrs.get("methods").length > 1) {
                context.isMultiMethod = true;
                context.supportedMethods = Arrays.asList((Object[])attrs.get("methods"));
            } else {
                context.method = attrs.get("methods")[0];
            }
        } else {
            context.method = null;
        }
        context.contentType = attrs.get("consumes") != null ? attrs.get("consumes")[0] : null;
        String path = attrs.get("path") != null ? attrs.get("path")[0] : null;
        context.path = context.getTemplatePath(path);
        return context;
    }

    private String getTemplatePath(String path) {
        if (path == null) {
            return null;
        }
        return path.replaceAll("\\{", "\\$\\{");
    }

    public String getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<ParameterContextHolder> getParameters() {
        return this.parameters;
    }

    public boolean isMultiMethod() {
        return this.isMultiMethod;
    }

    public List<String> getSupportedMethods() {
        return this.supportedMethods;
    }
}

