/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.client.generator.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class GeneratorUtils {
    public static AnnotationAttachmentNode getAnnotationFromList(String name, String pkg, List<? extends AnnotationAttachmentNode> annotations) {
        AnnotationAttachmentNode annotation = null;
        if (name == null || pkg == null) {
            return null;
        }
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            if (!pkg.equals(annotationAttachmentNode.getPackageAlias().getValue()) || !name.equals(annotationAttachmentNode.getAnnotationName().getValue())) continue;
            annotation = annotationAttachmentNode;
        }
        return annotation;
    }

    public static Map<String, String[]> getKeyValuePairAsMap(List<RecordLiteralNode.RecordField> list) {
        HashMap<String, String[]> attrMap = new HashMap<String, String[]>();
        for (RecordLiteralNode.RecordField field : list) {
            if (!field.isKeyValueField()) continue;
            BLangRecordLiteral.BLangRecordKeyValueField attr = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            if (attr.getValue() instanceof BLangLiteral) {
                attrMap.put(attr.getKey().toString(), new String[]{attr.getValue().toString()});
                continue;
            }
            if (!(attr.getValue() instanceof BLangListConstructorExpr)) continue;
            List exprs = ((BLangListConstructorExpr)attr.getValue()).getExpressions();
            String[] values = new String[exprs.size()];
            for (int i = 0; i < exprs.size(); ++i) {
                if (!(exprs.get(i) instanceof BLangLiteral)) continue;
                values[i] = ((BLangLiteral)exprs.get(i)).getValue().toString();
            }
            attrMap.put(attr.getKey().toString(), values);
        }
        return attrMap;
    }
}

