/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.BallerinaTextDocumentService;
import org.ballerinalang.langserver.BallerinaWorkspaceService;
import org.ballerinalang.langserver.Experimental;
import org.ballerinalang.langserver.LSAnnotationCache;
import org.ballerinalang.langserver.LSClientCapabilitiesImpl;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.LSGlobalContext;
import org.ballerinalang.langserver.LSGlobalContextKeys;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.client.ExtendedLanguageClientAware;
import org.ballerinalang.langserver.command.LSCommandExecutorProvidersHolder;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.workspace.WorkspaceDocumentManagerImpl;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;
import org.ballerinalang.langserver.extensions.ExtendedLanguageServer;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaDocumentService;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaDocumentServiceImpl;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleService;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleServiceImpl;
import org.ballerinalang.langserver.extensions.ballerina.fragment.BallerinaFragmentService;
import org.ballerinalang.langserver.extensions.ballerina.fragment.BallerinaFragmentServiceImpl;
import org.ballerinalang.langserver.extensions.ballerina.project.BallerinaProjectService;
import org.ballerinalang.langserver.extensions.ballerina.project.BallerinaProjectServiceImpl;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.ScopeEnum;
import org.ballerinalang.langserver.extensions.ballerina.symbol.BallerinaSymbolService;
import org.ballerinalang.langserver.extensions.ballerina.symbol.BallerinaSymbolServiceImpl;
import org.ballerinalang.langserver.extensions.ballerina.traces.BallerinaTraceService;
import org.ballerinalang.langserver.extensions.ballerina.traces.BallerinaTraceServiceImpl;
import org.ballerinalang.langserver.extensions.ballerina.traces.Listener;
import org.ballerinalang.langserver.extensions.ballerina.traces.ProviderOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class BallerinaLanguageServer
implements ExtendedLanguageServer,
ExtendedLanguageClientAware {
    private ExtendedLanguageClient client = null;
    private TextDocumentService textService;
    private WorkspaceService workspaceService;
    private BallerinaDocumentService ballerinaDocumentService;
    private BallerinaProjectService ballerinaProjectService;
    private BallerinaExampleService ballerinaExampleService;
    private BallerinaTraceService ballerinaTraceService;
    private Listener ballerinaTraceListener;
    private BallerinaSymbolService ballerinaSymbolService;
    private BallerinaFragmentService ballerinaFragmentService;
    private int shutdown = 1;

    public BallerinaLanguageServer() {
        this((WorkspaceDocumentManager)WorkspaceDocumentManagerImpl.getInstance());
    }

    public BallerinaLanguageServer(WorkspaceDocumentManager documentManager) {
        LSGlobalContext lsGlobalContext = new LSGlobalContext(LSContextOperation.LS_INIT);
        lsGlobalContext.put(LSGlobalContextKeys.LANGUAGE_SERVER_KEY, this);
        lsGlobalContext.put(LSGlobalContextKeys.DOCUMENT_MANAGER_KEY, documentManager);
        lsGlobalContext.put(LSGlobalContextKeys.DIAGNOSTIC_HELPER_KEY, DiagnosticsHelper.getInstance());
        this.textService = new BallerinaTextDocumentService(lsGlobalContext);
        this.workspaceService = new BallerinaWorkspaceService(lsGlobalContext);
        this.ballerinaDocumentService = new BallerinaDocumentServiceImpl(lsGlobalContext);
        this.ballerinaProjectService = new BallerinaProjectServiceImpl(lsGlobalContext);
        this.ballerinaExampleService = new BallerinaExampleServiceImpl();
        this.ballerinaTraceService = new BallerinaTraceServiceImpl(lsGlobalContext);
        this.ballerinaTraceListener = new Listener(this.ballerinaTraceService);
        this.ballerinaSymbolService = new BallerinaSymbolServiceImpl();
        this.ballerinaFragmentService = new BallerinaFragmentServiceImpl();
        LSAnnotationCache.initiate();
    }

    public ExtendedLanguageClient getClient() {
        return this.client;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        InitializeResult res = new InitializeResult(new ServerCapabilities());
        SignatureHelpOptions signatureHelpOptions = new SignatureHelpOptions(Arrays.asList("(", ","));
        List<String> commandList = LSCommandExecutorProvidersHolder.getInstance().getCommandsList();
        ExecuteCommandOptions executeCommandOptions = new ExecuteCommandOptions(commandList);
        CompletionOptions completionOptions = new CompletionOptions();
        completionOptions.setTriggerCharacters(Arrays.asList(":", ".", ">", "@"));
        res.getCapabilities().setCompletionProvider(completionOptions);
        res.getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        res.getCapabilities().setSignatureHelpProvider(signatureHelpOptions);
        res.getCapabilities().setHoverProvider(Boolean.valueOf(true));
        res.getCapabilities().setDocumentSymbolProvider(Boolean.valueOf(false));
        res.getCapabilities().setDefinitionProvider(Boolean.valueOf(true));
        res.getCapabilities().setReferencesProvider(Boolean.valueOf(false));
        res.getCapabilities().setCodeActionProvider(Boolean.valueOf(true));
        res.getCapabilities().setExecuteCommandProvider(executeCommandOptions);
        res.getCapabilities().setDocumentFormattingProvider(Boolean.valueOf(true));
        res.getCapabilities().setRenameProvider(Boolean.valueOf(false));
        res.getCapabilities().setWorkspaceSymbolProvider(Boolean.valueOf(false));
        res.getCapabilities().setImplementationProvider(Boolean.valueOf(false));
        HashMap experimentalClientCapabilities = null;
        if (params.getCapabilities().getExperimental() != null) {
            experimentalClientCapabilities = (HashMap)new Gson().fromJson(params.getCapabilities().getExperimental().toString(), HashMap.class);
        }
        HashMap<String, Object> experimentalServerCapabilities = new HashMap<String, Object>();
        experimentalServerCapabilities.put(Experimental.AST_PROVIDER.getValue(), true);
        experimentalServerCapabilities.put(Experimental.EXAMPLES_PROVIDER.getValue(), true);
        experimentalServerCapabilities.put(Experimental.API_EDITOR_PROVIDER.getValue(), true);
        if (experimentalClientCapabilities != null) {
            Object semanticHighlighterObj;
            Object introspectionObj = experimentalClientCapabilities.get(Experimental.INTROSPECTION.getValue());
            if (introspectionObj instanceof Boolean && ((Boolean)introspectionObj).booleanValue()) {
                int port = this.ballerinaTraceListener.startListener();
                experimentalServerCapabilities.put(Experimental.INTROSPECTION.getValue(), new ProviderOptions(port));
            }
            if ((semanticHighlighterObj = experimentalClientCapabilities.get(Experimental.SEMANTIC_SYNTAX_HIGHLIGHTER.getValue())) instanceof Boolean && ((Boolean)semanticHighlighterObj).booleanValue()) {
                experimentalServerCapabilities.put(Experimental.SEMANTIC_SYNTAX_HIGHLIGHTER.getValue(), true);
                String[][] scopes = this.getScopes();
                experimentalServerCapabilities.put(Experimental.SEMANTIC_SCOPES.getValue(), scopes);
            }
        }
        res.getCapabilities().setExperimental(experimentalServerCapabilities);
        TextDocumentClientCapabilities textDocClientCapabilities = params.getCapabilities().getTextDocument();
        WorkspaceClientCapabilities workspaceClientCapabilities = params.getCapabilities().getWorkspace();
        LSClientCapabilitiesImpl capabilities = new LSClientCapabilitiesImpl(textDocClientCapabilities, workspaceClientCapabilities, experimentalClientCapabilities);
        ((BallerinaTextDocumentService)this.textService).setClientCapabilities(capabilities);
        ((BallerinaWorkspaceService)this.workspaceService).setClientCapabilities(capabilities);
        return CompletableFuture.supplyAsync(() -> res);
    }

    public CompletableFuture<Object> shutdown() {
        this.shutdown = 0;
        this.ballerinaTraceListener.stopListener();
        return CompletableFuture.supplyAsync(Object::new);
    }

    public void exit() {
        System.exit(this.shutdown);
    }

    public TextDocumentService getTextDocumentService() {
        return this.textService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    @Override
    public BallerinaDocumentService getBallerinaDocumentService() {
        return this.ballerinaDocumentService;
    }

    @Override
    public BallerinaExampleService getBallerinaExampleService() {
        return this.ballerinaExampleService;
    }

    @Override
    public BallerinaProjectService getBallerinaProjectService() {
        return this.ballerinaProjectService;
    }

    @Override
    public BallerinaTraceService getBallerinaTraceService() {
        return this.ballerinaTraceService;
    }

    @Override
    public void connect(ExtendedLanguageClient languageClient) {
        this.client = languageClient;
        LSClientLogger.initialize((LanguageClient)this.client);
    }

    @Override
    public BallerinaSymbolService getBallerinaSymbolService() {
        return this.ballerinaSymbolService;
    }

    @Override
    public BallerinaFragmentService getBallerinaFragmentService() {
        return this.ballerinaFragmentService;
    }

    private String[][] getScopes() {
        String[][] scopes = new String[2][1];
        scopes[0][0] = ScopeEnum.ENDPOINT.getScopeName();
        scopes[1][0] = ScopeEnum.UNUSED.getScopeName();
        return scopes;
    }
}

