/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.codeaction.spi.LSCodeActionProvider;

public class CodeActionProvidersHolder {
    private static Map<CodeActionNodeType, List<LSCodeActionProvider>> nodeBasedProviders = new HashMap<CodeActionNodeType, List<LSCodeActionProvider>>();
    private static List<LSCodeActionProvider> diagnosticsBasedProviders = new ArrayList<LSCodeActionProvider>();
    private static final CodeActionProvidersHolder INSTANCE = new CodeActionProvidersHolder();

    public static CodeActionProvidersHolder getInstance() {
        return INSTANCE;
    }

    private CodeActionProvidersHolder() {
        ServiceLoader<LSCodeActionProvider> serviceLoader = ServiceLoader.load(LSCodeActionProvider.class);
        for (CodeActionNodeType nodeType : CodeActionNodeType.values()) {
            nodeBasedProviders.put(nodeType, new ArrayList());
        }
        for (LSCodeActionProvider provider : serviceLoader) {
            if (provider.isNodeBasedSupported()) {
                for (CodeActionNodeType nodeType : provider.getCodeActionNodeTypes()) {
                    switch (nodeType) {
                        case IMPORTS: {
                            nodeBasedProviders.get(CodeActionNodeType.IMPORTS).add(provider);
                            break;
                        }
                        case FUNCTION: {
                            nodeBasedProviders.get(CodeActionNodeType.FUNCTION).add(provider);
                            break;
                        }
                        case OBJECT: {
                            nodeBasedProviders.get(CodeActionNodeType.OBJECT).add(provider);
                            break;
                        }
                        case SERVICE: {
                            nodeBasedProviders.get(CodeActionNodeType.SERVICE).add(provider);
                            break;
                        }
                        case RECORD: {
                            nodeBasedProviders.get(CodeActionNodeType.RECORD).add(provider);
                            break;
                        }
                        case RESOURCE: {
                            nodeBasedProviders.get(CodeActionNodeType.RESOURCE).add(provider);
                            break;
                        }
                        case OBJECT_FUNCTION: {
                            nodeBasedProviders.get(CodeActionNodeType.OBJECT_FUNCTION).add(provider);
                            break;
                        }
                    }
                }
            }
            if (!provider.isDiagBasedSupported()) continue;
            diagnosticsBasedProviders.add(provider);
        }
    }

    Map<CodeActionNodeType, List<LSCodeActionProvider>> getNodeBasedProviders() {
        return nodeBasedProviders;
    }

    List<LSCodeActionProvider> getDiagnosticsBasedProviders() {
        return diagnosticsBasedProviders;
    }
}

