/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.codeaction.spi.LSCodeActionProvider;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public abstract class AbstractCodeActionProvider
implements LSCodeActionProvider {
    private List<CodeActionNodeType> codeActionNodeTypes;
    private final boolean isNodeTypeBased;

    public AbstractCodeActionProvider() {
        this.isNodeTypeBased = false;
    }

    public AbstractCodeActionProvider(List<CodeActionNodeType> nodeTypes) {
        this.codeActionNodeTypes = nodeTypes;
        this.isNodeTypeBased = true;
    }

    public abstract List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType var1, LSContext var2, List<Diagnostic> var3);

    public abstract List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType var1, LSContext var2, List<Diagnostic> var3, List<Diagnostic> var4);

    public final boolean isNodeBasedSupported() {
        return this.isNodeTypeBased;
    }

    public final boolean isDiagBasedSupported() {
        return !this.isNodeTypeBased;
    }

    public final List<CodeActionNodeType> getCodeActionNodeTypes() {
        return this.codeActionNodeTypes;
    }

    protected static String getDiagnosedContent(Diagnostic diagnostic, LSContext context, LSDocumentIdentifier document) {
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        StringBuilder content = new StringBuilder();
        Position start = diagnostic.getRange().getStart();
        Position end = diagnostic.getRange().getEnd();
        try (BufferedReader reader = new BufferedReader(new StringReader(docManager.getFileContent(document.getPath())));){
            String strLine;
            int count = 0;
            while ((strLine = reader.readLine()) != null) {
                if (count >= start.getLine() && count <= end.getLine()) {
                    if (count == start.getLine()) {
                        content.append(strLine.substring(start.getCharacter()));
                        if (start.getLine() != end.getLine()) {
                            content.append(System.lineSeparator());
                        }
                    } else if (count == end.getLine()) {
                        content.append(strLine.substring(0, end.getCharacter()));
                    } else {
                        content.append(strLine).append(System.lineSeparator());
                    }
                }
                if (count == end.getLine()) {
                    break;
                }
                ++count;
            }
        }
        catch (IOException | WorkspaceDocumentException throwable) {
            // empty catch block
        }
        return content.toString();
    }

    protected static Position offsetPositionToInvocation(String diagnosedContent, Position position) {
        int bal;
        String content = diagnosedContent.trim();
        int len = content.length();
        --len;
        if (content.charAt(0) == '{' && content.charAt(len) == ';' && content.charAt(--len) == '}') {
            return position;
        }
        if (content.charAt(0) == '<' && content.charAt(len) == ';') {
            return position;
        }
        if (content.startsWith("from ")) {
            return position;
        }
        int pendingLParenthesis = 0;
        boolean loop = true;
        boolean insideString = false;
        int count = 0;
        int pointer = content.length();
        while (loop) {
            Optional tail2ndPrevChar;
            --pointer;
            if (content.length() == 1) {
                ++count;
                break;
            }
            char tailChar = content.charAt(pointer);
            char tailPrevChar = content.charAt(pointer - 1);
            Optional<Object> optional = tail2ndPrevChar = pointer > 1 ? Optional.of(Character.valueOf(content.charAt(pointer - 2))) : Optional.empty();
            if (tailChar == '\"' && tailPrevChar != '\\') {
                boolean bl = insideString = !insideString;
            }
            if (!insideString) {
                if (pendingLParenthesis <= 0) {
                    boolean isRangeExpr;
                    boolean bl = isRangeExpr = tail2ndPrevChar.isPresent() && (tailChar == '.' || tailChar == '<') && tailPrevChar == '.' && ((Character)tail2ndPrevChar.get()).charValue() == '.';
                    if (isRangeExpr) {
                        pointer -= 2;
                        count += 2;
                    } else {
                        if (tailChar == '.' || tailChar == ':') {
                            ++count;
                            break;
                        }
                        if (tailPrevChar == '-' && tailChar == '>') break;
                    }
                }
                if (tailChar == '(') {
                    --pendingLParenthesis;
                } else if (tailChar == ')') {
                    ++pendingLParenthesis;
                }
            }
            content = content.substring(0, pointer);
            ++count;
        }
        if ((bal = diagnosedContent.length() - count) > 0) {
            position = new Position(position.getLine(), position.getCharacter() + bal + 1);
        }
        return position;
    }
}

