/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ImplementFunctionsCodeAction
extends AbstractCodeActionProvider {
    private static final String NO_IMPL_FOUND_FOR_FUNCTION = "no implementation found for the function";

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        ArrayList<DiagnosticPos> addedObjPosition = new ArrayList<DiagnosticPos>();
        BLangPackage bLangPackage = (BLangPackage)lsContext.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        if (bLangPackage == null) {
            return actions;
        }
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            CodeAction codeAction;
            if (!diagnostic.getMessage().startsWith(NO_IMPL_FOUND_FOR_FUNCTION) || (codeAction = ImplementFunctionsCodeAction.getNoImplementationFoundCommand(diagnostic, addedObjPosition, bLangPackage, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static CodeAction getNoImplementationFoundCommand(Diagnostic diagnostic, List<DiagnosticPos> addedObjPosition, BLangPackage bLangPackage, LSContext context) {
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        Optional<BLangTypeDefinition> objType = bLangPackage.topLevelNodes.stream().filter(topLevelNode -> {
            if (topLevelNode instanceof BLangTypeDefinition) {
                Diagnostic.DiagnosticPosition pos = topLevelNode.getPosition();
                return (pos.getStartLine() == line || pos.getEndLine() == line || pos.getStartLine() < line && pos.getEndLine() > line) && pos.getStartColumn() <= column && pos.getEndColumn() <= column;
            }
            return false;
        }).findAny().map(t -> (BLangTypeDefinition)t);
        ArrayList edits = new ArrayList();
        if (objType.isPresent()) {
            BLangTypeDefinition typeDefinition = objType.get();
            if (addedObjPosition.contains(typeDefinition.pos)) {
                return null;
            }
            addedObjPosition.add(typeDefinition.pos);
            BTypeSymbol symbol = typeDefinition.symbol;
            if (symbol instanceof BObjectTypeSymbol) {
                BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)symbol;
                typeSymbol.referencedFunctions.stream().filter(func -> !func.symbol.bodyExist).forEach(func -> edits.addAll(ImplementFunctionsCodeAction.getNewFunctionEditText(func, (BLangTypeDefinition)objType.get(), bLangPackage, context)));
            }
        }
        if (!edits.isEmpty()) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            diagnostics.add(diagnostic);
            String commandTitle = "Implement All Functions";
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits)))));
            action.setDiagnostics(diagnostics);
            return action;
        }
        return null;
    }

    private static List<TextEdit> getNewFunctionEditText(BAttachedFunction function, BLangTypeDefinition object, BLangPackage packageNode, LSContext context) {
        String funcArgs = "";
        PackageID currentPkgId = packageNode.packageID;
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        BiConsumer<String, String> importsAcceptor = (orgName, alias) -> {
            boolean notFound = packageNode.getImports().stream().noneMatch(pkg -> pkg.orgName.value.equals(orgName) && pkg.alias.value.equals(alias));
            if (notFound) {
                String pkgName = orgName + "/" + alias;
                edits.add(ImplementFunctionsCodeAction.createPackageImportTextEdit(pkgName, context));
            }
        };
        String returnType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, function.type.retType);
        String returnValue = FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, function.type.retType, "        return {%1};");
        List<String> arguments = ImplementFunctionsCodeAction.getFuncArguments(importsAcceptor, currentPkgId, function.symbol);
        if (arguments != null) {
            funcArgs = String.join((CharSequence)", ", arguments);
        }
        boolean prependLineFeed = false;
        if (object.typeNode instanceof BLangObjectTypeNode) {
            BLangObjectTypeNode typeNode = (BLangObjectTypeNode)object.typeNode;
            prependLineFeed = typeNode.functions.size() > 0;
        }
        boolean isPublic = (function.type.tsymbol.flags & 1) == 1;
        String modifiers = isPublic ? "public " : "";
        String editText = FunctionGenerator.createFunction(function.funcName.value, funcArgs, returnType, returnValue, modifiers, false, StringUtils.repeat((char)' ', (int)4));
        Position editPos = new Position(object.pos.eLine - 1, 0);
        edits.add(new TextEdit(new Range(editPos, editPos), editText));
        return edits;
    }

    private static List<String> getFuncArguments(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BInvokableSymbol bLangInvocation) {
        ArrayList<String> list = new ArrayList<String>();
        if (bLangInvocation.params.isEmpty()) {
            return null;
        }
        for (BVarSymbol bVarSymbol : bLangInvocation.params) {
            String argType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, bVarSymbol.type);
            String argName = bVarSymbol.name.value;
            list.add(argType + " " + argName);
        }
        BVarSymbol restParam = bLangInvocation.restParam;
        if (restParam != null && restParam.type instanceof BArrayType) {
            String argType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, ((BArrayType)restParam.type).eType);
            list.add(argType + "... " + restParam.getName().getValue());
        }
        return !list.isEmpty() ? list : null;
    }

    private static TextEdit createPackageImportTextEdit(String pkgName, LSContext context) {
        DiagnosticPos pos = null;
        List<BLangImportPackage> imports = CommonUtil.getCurrentFileImports(context);
        if (!imports.isEmpty()) {
            BLangImportPackage lastImport = CommonUtil.getLastItem(imports);
            pos = lastImport.getPosition();
        }
        int endCol = 0;
        int endLine = pos == null ? 0 : pos.getEndLine();
        String editText = "import " + pkgName + ";\n";
        Range range = new Range(new Position(endLine, endCol), new Position(endLine, endCol));
        return new TextEdit(range, editText);
    }
}

