/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSPackageLoader;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;

public class ImportModuleCodeAction
extends AbstractCodeActionProvider {
    private static final String UNDEFINED_FUNCTION = "undefined function";
    private static final String UNDEFINED_MODULE = "undefined module";
    private static final String UNRESOLVED_MODULE = "cannot resolve module";

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        Optional<Path> filePath = CommonUtil.getPathFromURI((String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY));
        LSDocumentIdentifier document = null;
        try {
            document = documentManager.getLSDocument(filePath.get());
        }
        catch (WorkspaceDocumentException workspaceDocumentException) {
            // empty catch block
        }
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        if (document == null) {
            return actions;
        }
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            if (!diagnostic.getMessage().startsWith(UNDEFINED_MODULE)) continue;
            List<CodeAction> codeActions = ImportModuleCodeAction.getModuleImportCommand(diagnostic, lsContext);
            actions.addAll(codeActions);
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static List<CodeAction> getModuleImportCommand(Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        String packageAlias = diagnosticMessage.substring(diagnosticMessage.indexOf("'") + 1, diagnosticMessage.lastIndexOf("'"));
        LSDocumentIdentifierImpl sourceDocument = new LSDocumentIdentifierImpl(uri);
        String sourceRoot = LSCompilerUtil.getProjectRoot((Path)sourceDocument.getPath());
        sourceDocument.setProjectRootRoot(sourceRoot);
        ArrayList packagesList = new ArrayList();
        Stream.of(LSPackageLoader.getSdkPackages(), LSPackageLoader.getHomeRepoPackages()).forEach(packagesList::addAll);
        packagesList.stream().filter(pkgEntry -> {
            String fullPkgName = pkgEntry.getFullPackageNameAlias();
            return fullPkgName.endsWith("." + packageAlias) || fullPkgName.endsWith("/" + packageAlias);
        }).forEach(pkgEntry -> {
            String commandTitle = "Import Module  " + pkgEntry.getFullPackageNameAlias();
            CommandArgument pkgArgument = new CommandArgument("module", pkgEntry.getFullPackageNameAlias());
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setCommand(new Command(commandTitle, "IMPORT_MODULE", new ArrayList<CommandArgument>(Arrays.asList(pkgArgument, uriArg))));
            action.setDiagnostics(diagnostics);
            actions.add(action);
        });
        return actions;
    }
}

