/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CreateFunctionExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "CREATE_FUNC";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        String returnValue;
        String returnType;
        String fileContent;
        String documentUri = null;
        String funcArgs = "";
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        int line = -1;
        int column = -1;
        for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            String argKey = ((JsonObject)arg).get("argumentK").getAsString();
            String argVal = ((JsonObject)arg).get("argumentV").getAsString();
            switch (argKey) {
                case "doc.uri": {
                    documentUri = argVal;
                    textDocumentIdentifier.setUri(documentUri);
                    context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
                    break;
                }
                case "node.line": {
                    line = Integer.parseInt(argVal);
                    break;
                }
                case "node.column": {
                    column = Integer.parseInt(argVal);
                    break;
                }
            }
        }
        if (line == -1 || column == -1 || documentUri == null) {
            throw new LSCommandExecutorException("Invalid parameters received for the create function command!");
        }
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        BLangInvocation functionNode = null;
        try {
            LSDocumentIdentifier lsDocument = docManager.getLSDocument(CommonUtil.getPathFromURI(documentUri).get());
            Position pos = new Position(line, column + 1);
            context.put(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST, (Object)true);
            context.put(ReferencesKeys.DO_NOT_SKIP_NULL_SYMBOLS, (Object)true);
            SymbolReferencesModel.Reference refAtCursor = ReferencesUtil.getReferenceAtCursor(context, lsDocument, pos);
            BLangNode bLangNode = refAtCursor.getbLangNode();
            if (bLangNode instanceof BLangInvocation) {
                functionNode = (BLangInvocation)bLangNode;
            }
        }
        catch (WorkspaceDocumentException | CompilationFailedException e) {
            throw new LSCommandExecutorException("Error while compiling the source!");
        }
        if (functionNode == null) {
            throw new LSCommandExecutorException("Couldn't find the function node!");
        }
        String functionName = functionNode.name.getValue();
        Path filePath = Paths.get(URI.create(documentUri));
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.toString()).orElse(filePath);
        try {
            fileContent = docManager.getFileContent(compilationPath);
        }
        catch (WorkspaceDocumentException e) {
            throw new LSCommandExecutorException("Error occurred while reading the file:" + filePath.toString(), (Throwable)e);
        }
        BLangNode parent = functionNode.parent;
        BLangPackage packageNode = CommonUtil.getPackageNode((BLangNode)functionNode);
        String[] contentComponents = fileContent.split("\\n|\\r\\n|\\r");
        int eLine = contentComponents.length;
        int lastNewLineCharIndex = Math.max(fileContent.lastIndexOf(10), fileContent.lastIndexOf(13));
        int eCol = fileContent.substring(lastNewLineCharIndex + 1).length();
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        if (parent != null && packageNode != null) {
            PackageID currentPkgId = packageNode.packageID;
            BiConsumer<String, String> importsAcceptor = (orgName, alias) -> {
                boolean notFound = packageNode.getImports().stream().noneMatch(pkg -> pkg.orgName.value.equals(orgName) && pkg.alias.value.equals(alias));
                if (notFound) {
                    String pkgName = orgName + "/" + alias;
                    edits.add(this.addPackage(pkgName, context));
                }
            };
            returnType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, parent);
            returnValue = FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, parent, "    return {%1};");
            List<String> arguments = FunctionGenerator.getFuncArguments(importsAcceptor, currentPkgId, (BLangNode)functionNode, context);
            if (arguments != null) {
                funcArgs = String.join((CharSequence)", ", arguments);
            }
        } else {
            throw new LSCommandExecutorException("Error occurred when retrieving function node!");
        }
        LanguageClient client = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
        String modifiers = "";
        boolean prependLineFeed = true;
        String padding = "";
        if (functionNode.expr != null) {
            padding = StringUtils.repeat((char)' ', (int)4);
            BTypeSymbol tSymbol = functionNode.expr.type.tsymbol;
            Pair<DiagnosticPos, Boolean> nodeLocation = this.getNodeLocationAndHasFunctions(tSymbol.name.value, context);
            if (!((Boolean)nodeLocation.getRight()).booleanValue()) {
                prependLineFeed = false;
            }
            eLine = ((DiagnosticPos)nodeLocation.getLeft()).eLine - 1;
            eCol = 0;
            String cUnitName = ((DiagnosticPos)nodeLocation.getLeft()).src.cUnitName;
            String sourceRoot = (String)context.get(DocumentServiceKeys.SOURCE_ROOT_KEY);
            String pkgName = ((DiagnosticPos)nodeLocation.getLeft()).src.pkgID.name.toString();
            String uri = new File(sourceRoot).toPath().resolve("src").resolve(pkgName).resolve(cUnitName).toUri().toString();
            textDocumentIdentifier.setUri(uri);
            if (!((DiagnosticPos)nodeLocation.getLeft()).src.pkgID.equals((Object)functionNode.pos.src.pkgID)) {
                modifiers = modifiers + "public ";
            }
        }
        String editText = FunctionGenerator.createFunction(functionName, funcArgs, returnType, returnValue, modifiers, prependLineFeed, padding);
        Range range = new Range(new Position(eLine, eCol), new Position(eLine, eCol));
        edits.add(new TextEdit(range, editText));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(textDocumentIdentifier, edits);
        return CommandUtil.applyWorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)), client);
    }

    private Pair<DiagnosticPos, Boolean> getNodeLocationAndHasFunctions(String name, LSContext context) {
        List bLangPackages = (List)context.get(DocumentServiceKeys.BLANG_PACKAGES_CONTEXT_KEY);
        boolean hasFunctions = false;
        for (BLangPackage bLangPackage : bLangPackages) {
            for (BLangCompilationUnit cUnit : bLangPackage.getCompilationUnits()) {
                for (TopLevelNode node : cUnit.getTopLevelNodes()) {
                    if (!(node instanceof BLangTypeDefinition)) continue;
                    BLangTypeDefinition typeDefinition = (BLangTypeDefinition)node;
                    if (!typeDefinition.name.value.equals(name)) continue;
                    DiagnosticPos pos = typeDefinition.getPosition();
                    if (typeDefinition.symbol instanceof BObjectTypeSymbol) {
                        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)typeDefinition.symbol;
                        hasFunctions = typeSymbol.attachedFuncs.size() > 0;
                    }
                    return new ImmutablePair((Object)pos, (Object)hasFunctions);
                }
            }
        }
        return new ImmutablePair(null, (Object)hasFunctions);
    }

    private TextEdit addPackage(String pkgName, LSContext context) {
        DiagnosticPos pos = null;
        List<BLangImportPackage> imports = CommonUtil.getCurrentFileImports(context);
        if (!imports.isEmpty()) {
            BLangImportPackage lastImport = CommonUtil.getLastItem(imports);
            pos = lastImport.getPosition();
        }
        int endCol = 0;
        int endLine = pos == null ? 0 : pos.getEndLine();
        String editText = "import " + pkgName + ";\n";
        Range range = new Range(new Position(endLine, endCol), new Position(endLine, endCol));
        return new TextEdit(range, editText);
    }

    public String getCommand() {
        return COMMAND;
    }
}

