/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.BallerinaWorkspaceService;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.command.testgen.TestGenerator;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CreateTestExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "CREATE_TEST";

    public static String generateTestFileName(Path sourceFilePath) {
        String fileName = FilenameUtils.removeExtension((String)sourceFilePath.toFile().getName());
        return fileName + "_test" + ".bal";
    }

    private static ImmutablePair<Path, Path> createTestFolderIfNotExists(Path sourceFilePath) {
        Path projectRoot = Paths.get(LSCompilerUtil.getProjectRoot((Path)sourceFilePath), new String[0]);
        ImmutablePair<Path, Path> testsDirPath = CreateTestExecutor.getTestsDirPath(sourceFilePath, projectRoot);
        ((Path)testsDirPath.getRight()).toFile().mkdirs();
        return testsDirPath;
    }

    private static ImmutablePair<Path, Path> getTestsDirPath(Path sourceFilePath, Path projectRoot) {
        if (sourceFilePath == null || projectRoot == null) {
            return null;
        }
        Path currentModulePath = projectRoot;
        Path prevSourceRoot = sourceFilePath.getParent();
        ArrayList<String> pathParts = new ArrayList<String>();
        try {
            while (prevSourceRoot != null) {
                Path newSourceRoot = prevSourceRoot.getParent();
                currentModulePath = prevSourceRoot;
                if (newSourceRoot != null && !Files.isSameFile(newSourceRoot, projectRoot)) {
                    pathParts.add(prevSourceRoot.getFileName().toString());
                    prevSourceRoot = newSourceRoot;
                    continue;
                }
                break;
            }
        }
        catch (IOException newSourceRoot) {
            // empty catch block
        }
        Path testDirPath = currentModulePath.resolve("tests");
        for (String part : pathParts) {
            testDirPath = testDirPath.resolve(part);
        }
        return new ImmutablePair((Object)currentModulePath, (Object)testDirPath);
    }

    public Object execute(LSContext context) throws LSCommandExecutorException {
        BLangPackage builtSourceFile;
        String docUri = null;
        int line = -1;
        int column = -1;
        for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            String argKey = ((JsonObject)arg).get("argumentK").getAsString();
            String argVal = ((JsonObject)arg).get("argumentV").getAsString();
            switch (argKey) {
                case "doc.uri": {
                    docUri = argVal;
                    context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)docUri);
                    break;
                }
                case "node.line": {
                    line = Integer.parseInt(argVal);
                    break;
                }
                case "node.column": {
                    column = Integer.parseInt(argVal);
                    break;
                }
            }
        }
        if (line == -1 || column == -1 || docUri == null) {
            throw new LSCommandExecutorException("Invalid parameters received for the create test command!");
        }
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        try {
            builtSourceFile = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)docManager, null, (boolean)false, (boolean)false);
        }
        catch (CompilationFailedException e) {
            throw new LSCommandExecutorException("Couldn't compile the source", (Throwable)e);
        }
        LanguageServer languageServer = (LanguageServer)context.get(ExecuteCommandKeys.LANGUAGE_SERVER_KEY);
        BallerinaWorkspaceService workspace = null;
        if (languageServer instanceof BallerinaLanguageServer) {
            BallerinaLanguageServer ballerinaLanguageServer = (BallerinaLanguageServer)languageServer;
            workspace = (BallerinaWorkspaceService)ballerinaLanguageServer.getWorkspaceService();
        }
        LanguageClient client = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
        try {
            if (builtSourceFile == null || builtSourceFile.diagCollector.hasErrors()) {
                String message = "Test generation failed due to compilation errors!";
                if (client != null) {
                    client.showMessage(new MessageParams(MessageType.Error, message));
                }
                throw new LSCommandExecutorException(message);
            }
            Path filePath = Paths.get(URI.create(docUri));
            ImmutablePair<Path, Path> testDirs = CreateTestExecutor.createTestFolderIfNotExists(filePath);
            File testsDir = ((Path)testDirs.getRight()).toFile();
            File testFile = testsDir.toPath().resolve(CreateTestExecutor.generateTestFileName(filePath)).toFile();
            String pkgRelativeSourceFilePath = ((Path)testDirs.getLeft()).relativize(filePath).toString();
            LSDocumentIdentifier lsDocument = docManager.getLSDocument(filePath);
            Position pos = new Position(line, column + 1);
            context.put(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST, (Object)true);
            SymbolReferencesModel.Reference refAtCursor = ReferencesUtil.getReferenceAtCursor(context, lsDocument, pos);
            BLangNode bLangNode = refAtCursor.getbLangNode();
            Position position = new Position(0, 0);
            Range focus = new Range(position, position);
            BiConsumer<Integer, Integer> focusLineAcceptor = (focusLine, incrementer) -> {
                if (focusLine != null) {
                    position.setLine(focusLine.intValue());
                }
                position.setLine(position.getLine() + incrementer);
            };
            List<TextEdit> content = TestGenerator.generate(docManager, bLangNode, focusLineAcceptor, builtSourceFile, pkgRelativeSourceFilePath, testFile);
            ArrayList<Either> edits = new ArrayList<Either>();
            if (!testFile.exists()) {
                edits.add(Either.forRight((Object)new CreateFile(testFile.toPath().toUri().toString())));
            }
            VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier();
            identifier.setUri(testFile.toPath().toUri().toString());
            TextDocumentEdit textEdit = new TextDocumentEdit(identifier, content);
            edits.add(Either.forLeft((Object)textEdit));
            WorkspaceEdit workspaceEdit = new WorkspaceEdit(edits);
            ApplyWorkspaceEditParams editParams = new ApplyWorkspaceEditParams(workspaceEdit);
            if (client != null) {
                client.applyEdit(editParams);
                String message = "Tests generated into the file:" + testFile.toString();
                client.showMessage(new MessageParams(MessageType.Info, message));
                LSClientCapabilities clientCapabilities = (LSClientCapabilities)context.get(ExecuteCommandKeys.LS_CLIENT_CAPABILITIES_KEY);
                if (clientCapabilities.getExperimentalCapabilities().isShowTextDocumentEnabled()) {
                    this.showTextDocument(workspace, client, focus, identifier);
                }
            }
            return editParams;
        }
        catch (TestGeneratorException | WorkspaceDocumentException | CompilationFailedException e) {
            String message = "Test generation failed!: " + e.getMessage();
            if (client != null) {
                client.showMessage(new MessageParams(MessageType.Error, message));
            }
            throw new LSCommandExecutorException(message, e);
        }
    }

    private void showTextDocument(BallerinaWorkspaceService workspace, LanguageClient client, Range focus, VersionedTextDocumentIdentifier identifier) {
        if (workspace != null && client instanceof ExtendedLanguageClient) {
            Location location = new Location(identifier.getUri(), focus);
            ((ExtendedLanguageClient)client).showTextDocument(location);
        }
    }

    public String getCommand() {
        return COMMAND;
    }
}

