/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.util.List;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

public class MessageExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "MESSAGE";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        MessageType messageType = null;
        String message = "";
        for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            String argKey = ((JsonObject)arg).get("argumentK").getAsString();
            String argVal = ((JsonObject)arg).get("argumentV").getAsString();
            switch (argKey) {
                case "message.type": {
                    messageType = MessageType.forValue((int)Integer.parseInt(argVal));
                    break;
                }
                case "message": {
                    message = argVal;
                    break;
                }
            }
        }
        if (messageType == null || message.isEmpty()) {
            return new Object();
        }
        LanguageClient client = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
        client.showMessage(new MessageParams());
        CommandUtil.notifyClient(client, messageType, message);
        return new Object();
    }

    public String getCommand() {
        return COMMAND;
    }
}

