/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

public class PullModuleExecutor
implements LSCommandExecutor {
    private static ExecutorService executor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    public static final String COMMAND = "PULL_MODULE";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        executor.submit(() -> {
            String moduleName = "";
            String documentUri = "";
            for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
                String argKey = ((JsonObject)arg).get("argumentK").getAsString();
                String argVal = ((JsonObject)arg).get("argumentV").getAsString();
                switch (argKey) {
                    case "module": {
                        moduleName = argVal;
                        break;
                    }
                    case "doc.uri": {
                        documentUri = argVal;
                    }
                }
            }
            if (moduleName.isEmpty() || documentUri.isEmpty()) {
                return;
            }
            String ballerinaCmd = Paths.get(CommonUtil.BALLERINA_CMD, new String[0]).toString();
            ProcessBuilder processBuilder = new ProcessBuilder(ballerinaCmd, "pull", moduleName);
            LanguageClient client = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
            DiagnosticsHelper diagnosticsHelper = DiagnosticsHelper.getInstance();
            try {
                CommandUtil.notifyClient(client, MessageType.Info, "Pulling '" + moduleName + "' from the Ballerina Central...");
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                int data = inputStream.read();
                while (data != -1) {
                    data = inputStream.read();
                }
                InputStream errorStream = process.getErrorStream();
                String error = IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
                if (error == null || error.isEmpty()) {
                    CommandUtil.notifyClient(client, MessageType.Info, "Pulling success for the '" + moduleName + "' module!");
                    if (client instanceof ExtendedLanguageClient) {
                        CommandUtil.clearDiagnostics((ExtendedLanguageClient)client, diagnosticsHelper, documentUri, context);
                    }
                } else {
                    CommandUtil.notifyClient(client, MessageType.Error, "Pulling failed for the '" + moduleName + "' module!\n" + error);
                }
            }
            catch (IOException e) {
                CommandUtil.notifyClient(client, MessageType.Error, "Pulling failed for the '" + moduleName + "' module!");
            }
        });
        return new Object();
    }

    public String getCommand() {
        return COMMAND;
    }
}

