/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors.openapi.ballerinatoopenapi;

import com.google.gson.JsonObject;
import io.swagger.models.ModelImpl;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiEndpointMapper;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiServiceMapper;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.command.executors.openapi.OpenApiCodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaFile;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.wso2.ballerinalang.compiler.SourceDirectoryManager;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CreateBallerinaServiceResourceExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "CREATE_SERVICE_RESOURCE_IN_OPENAPI";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        block31: {
            String documentUri = null;
            VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
            String resourcePath = null;
            int line = -1;
            int column = -1;
            for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
                String argKey = ((JsonObject)arg).get("argumentK").getAsString();
                String argVal = ((JsonObject)arg).get("argumentV").getAsString();
                switch (argKey) {
                    case "doc.uri": {
                        documentUri = argVal;
                        textDocumentIdentifier.setUri(documentUri);
                        context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
                        break;
                    }
                    case "node.line": {
                        line = Integer.parseInt(argVal);
                        break;
                    }
                    case "node.column": {
                        column = Integer.parseInt(argVal);
                        break;
                    }
                    case "path": {
                        resourcePath = argVal;
                        break;
                    }
                }
            }
            if (line == -1 || column == -1 || documentUri == null) {
                throw new LSCommandExecutorException("Invalid parameters received for the create function command!");
            }
            WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
            BLangFunction functionNode = null;
            BLangService serviceNode = null;
            try {
                LSDocumentIdentifier lsDocument = documentManager.getLSDocument(CommonUtil.getPathFromURI(documentUri).get());
                Position pos = new Position(line, column + 1);
                List<BLangPackage> pkg = OpenApiCodeActionUtil.getBLangPkg(context, lsDocument, pos);
                functionNode = OpenApiCodeActionUtil.getBLangFunction(pkg, pos);
                if (functionNode != null && functionNode.parent != null) {
                    BLangObjectTypeNode serviceObj = (BLangObjectTypeNode)functionNode.parent;
                    if (serviceObj.flagSet.contains(Flag.SERVICE) && serviceObj.parent != null) {
                        BLangNode typeDef = serviceObj.parent;
                        if (typeDef.parent != null) {
                            BLangPackage bLangPackage = (BLangPackage)typeDef.parent;
                            if (bLangPackage.services != null && bLangPackage.services.size() > 0) {
                                List services = bLangPackage.services;
                                for (BLangService service : services) {
                                    if (service.symbol.type.tsymbol.name != functionNode.symbol.owner.name) continue;
                                    serviceNode = service;
                                }
                            }
                        }
                    }
                }
                String contractURI = null;
                if (serviceNode != null) {
                    List annotations = serviceNode.annAttachments;
                    for (BLangAnnotationAttachment annotation : annotations) {
                        if (!(annotation.getExpression() instanceof BLangRecordLiteral)) continue;
                        BLangRecordLiteral recordLiteral = (BLangRecordLiteral)annotation.getExpression();
                        for (RecordLiteralNode.RecordField field : recordLiteral.getFields()) {
                            BLangLiteral value;
                            BLangSimpleVarRef contract;
                            String key;
                            BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                            BLangRecordLiteral.BLangRecordVarNameField keyExpr;
                            if (field.isKeyValueField()) {
                                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                                keyExpr = keyValue.getKey();
                                valueExpr = keyValue.getValue();
                            } else {
                                BLangRecordLiteral.BLangRecordVarNameField varNameField;
                                keyExpr = varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                                valueExpr = varNameField;
                            }
                            if (!(keyExpr instanceof BLangSimpleVarRef) || !(key = (contract = (BLangSimpleVarRef)keyExpr).getVariableName().getValue()).equals("contract") || !(valueExpr instanceof BLangLiteral) || !((value = (BLangLiteral)valueExpr).getValue() instanceof String)) continue;
                            contractURI = (String)value.getValue();
                        }
                    }
                }
                if (contractURI == null) break block31;
                String separator = File.separator;
                SourceDirectoryManager sourceDirectoryManager = SourceDirectoryManager.getInstance((CompilerContext)((CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY)));
                String sourceDir = sourceDirectoryManager.getSourceDirectory().getPath().toString();
                String filePath = serviceNode.getPosition().getSource().getPackageName() + separator + serviceNode.getPosition().getSource().getCompilationUnitName().replaceAll("\\w*\\.bal", "");
                String projectDir = filePath.contains(sourceDir) ? sourceDir : sourceDir + separator + "src" + separator + filePath;
                File file = null;
                if (contractURI.contains(projectDir)) {
                    file = new File(contractURI);
                } else {
                    try {
                        file = new File(Paths.get(projectDir, contractURI).toRealPath(new LinkOption[0]).toString());
                    }
                    catch (IOException e) {
                        contractURI = Paths.get(contractURI, new String[0]).toString();
                    }
                }
                if (file != null && file.exists()) {
                    contractURI = file.getAbsolutePath();
                }
                OpenAPI openAPI = CreateBallerinaServiceResourceExecutor.parseOpenAPIFile(contractURI);
                Path ballerinaPath = Paths.get(documentManager.getAllFilePaths().toArray()[0].toString(), new String[0]);
                String balSource = CreateBallerinaServiceResourceExecutor.readFromFile(ballerinaPath);
                String openAPIDefinitions = CreateBallerinaServiceResourceExecutor.generateOpenApiDefinitions(balSource, serviceNode.name.value, resourcePath);
                SwaggerConverter converter = new SwaggerConverter();
                SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(openAPIDefinitions);
                String openApiResource = Yaml.pretty((Object)converter.convert(result).getOpenAPI());
                OpenAPI openAPINew = new OpenAPIV3Parser().readContents(openApiResource).getOpenAPI();
                openAPINew.getPaths().forEach((s, path) -> openAPI.getPaths().addPathItem(s, path));
                String openApiResourceNew = Yaml.pretty((Object)openAPI);
                CreateBallerinaServiceResourceExecutor.writeFile(Paths.get(contractURI, new String[0]), openApiResourceNew);
            }
            catch (IOException | WorkspaceDocumentException | CompilationFailedException e) {
                throw new LSCommandExecutorException("Error while compiling the source!");
            }
        }
        return null;
    }

    static OpenAPI parseOpenAPIFile(String definitionURI) {
        Path contractPath = Paths.get(definitionURI, new String[0]);
        if (Files.exists(contractPath, new LinkOption[0]) && (definitionURI.endsWith(".yaml") || definitionURI.endsWith(".json"))) {
            return new OpenAPIV3Parser().read(definitionURI);
        }
        return null;
    }

    private static String readFromFile(Path servicePath) throws IOException {
        String source = FileUtils.readFileToString((File)servicePath.toFile(), (String)"UTF-8");
        return source;
    }

    public static String generateOpenApiDefinitions(String ballerinaSource, String serviceName, String resourcePath) {
        try {
            BallerinaFile ballerinaFile = ExtendedLSCompiler.compileContent((String)ballerinaSource, (CompilerPhase)CompilerPhase.DEFINE);
            BLangCompilationUnit topCompilationUnit = ballerinaFile.getBLangPackage().map(bLangPackage -> (BLangCompilationUnit)bLangPackage.getCompilationUnits().get(0)).orElse(null);
            if (topCompilationUnit == null) {
                return "Error";
            }
            String httpAlias = CreateBallerinaServiceResourceExecutor.getAlias(topCompilationUnit, "ballerina/http");
            String openApiAlias = CreateBallerinaServiceResourceExecutor.getAlias(topCompilationUnit, "ballerina/openapi");
            OpenApiServiceMapper openApiServiceMapper = new OpenApiServiceMapper(httpAlias, openApiAlias);
            ArrayList<BLangSimpleVariable> endpoints = new ArrayList<BLangSimpleVariable>();
            Swagger openapi = CreateBallerinaServiceResourceExecutor.getOpenApiDefinition(new Swagger(), openApiServiceMapper, serviceName, topCompilationUnit, endpoints, resourcePath);
            return openApiServiceMapper.generateOpenApiString(openapi);
        }
        catch (CompilationFailedException e) {
            return "Error";
        }
    }

    private static String getAlias(BLangCompilationUnit topCompilationUnit, String packageName) {
        for (TopLevelNode topLevelNode : topCompilationUnit.getTopLevelNodes()) {
            if (!(topLevelNode instanceof BLangImportPackage)) continue;
            BLangImportPackage importPackage = (BLangImportPackage)topLevelNode;
            String packagePath = importPackage.getPackageName().stream().map(BLangIdentifier::getValue).collect(Collectors.joining("."));
            packagePath = importPackage.getOrgName().toString() + '/' + packagePath;
            if (!packageName.equals(packagePath)) continue;
            return importPackage.getAlias().getValue();
        }
        return null;
    }

    private static Swagger getOpenApiDefinition(Swagger openapi, OpenApiServiceMapper openApiServiceMapper, String serviceName, BLangCompilationUnit topCompilationUnit, List<BLangSimpleVariable> endpoints, String resourcePath) {
        HashMap<String, ModelImpl> definitions = new HashMap<String, ModelImpl>();
        for (TopLevelNode topLevelNode : topCompilationUnit.getTopLevelNodes()) {
            if (topLevelNode instanceof BLangSimpleVariable && ((BLangSimpleVariable)topLevelNode).getFlags().contains(Flag.LISTENER)) {
                endpoints.add((BLangSimpleVariable)topLevelNode);
            }
            if (topLevelNode instanceof BLangService && openapi.getBasePath() == null) {
                BLangService serviceDefinition = (BLangService)topLevelNode;
                ArrayList<BLangFunction> unwantedFunctions = new ArrayList<BLangFunction>();
                for (BLangFunction resource : serviceDefinition.getResources()) {
                    for (SimpleVariableNode field : ((BLangRecordLiteral)((BLangAnnotationAttachment)resource.annAttachments.get((int)0)).expr).fields) {
                        if (!((BLangSimpleVarRef)((BLangRecordLiteral.BLangRecordKeyValueField)field).key.expr).variableName.value.equals("path") || ((BLangLiteral)((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr).value.equals(resourcePath)) continue;
                        unwantedFunctions.add(resource);
                    }
                }
                serviceDefinition.getResources().removeAll(unwantedFunctions);
                openapi = new OpenApiEndpointMapper().convertBoundEndpointsToOpenApi(endpoints, (ServiceNode)serviceDefinition, openapi);
                if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                    if (serviceDefinition.getName().getValue().equals(serviceName)) {
                        openapi = openApiServiceMapper.convertServiceToOpenApi(serviceDefinition, openapi);
                    }
                } else {
                    openapi = openApiServiceMapper.convertServiceToOpenApi(serviceDefinition, openapi);
                }
            }
            if (!(topLevelNode instanceof BLangTypeDefinition)) continue;
            BLangTypeDefinition typeNode = (BLangTypeDefinition)topLevelNode;
            if (!(typeNode.typeNode instanceof BLangRecordTypeNode)) continue;
            ModelImpl model = new ModelImpl();
            List fields = ((BLangRecordTypeNode)typeNode.typeNode).getFields();
            HashMap<String, Property> propertyMap = new HashMap<String, Property>();
            for (SimpleVariableNode field : fields) {
                Property openApiPropertyForBallerinaField = CreateBallerinaServiceResourceExecutor.createOpenApiPropertyForBallerinaField(field.getTypeNode());
                if (openApiPropertyForBallerinaField == null) continue;
                propertyMap.put(field.getName().getValue(), openApiPropertyForBallerinaField);
            }
            model.setProperties(propertyMap);
            definitions.put(typeNode.getName().getValue(), model);
            openapi.setDefinitions(definitions);
        }
        return openapi;
    }

    public static Property createOpenApiPropertyForBallerinaField(TypeNode node) {
        Property property = null;
        if (node instanceof BLangArrayType) {
            BLangArrayType fieldTypeNode = (BLangArrayType)node;
            ArrayProperty arr = new ArrayProperty();
            arr.setItems(CreateBallerinaServiceResourceExecutor.mapBallerinaTypes(fieldTypeNode.getElementType().type.getKind().typeName()));
            property = arr;
        } else if (node instanceof BLangBuiltInRefTypeNode) {
            BLangBuiltInRefTypeNode fieldTypeNode = (BLangBuiltInRefTypeNode)node;
            property = CreateBallerinaServiceResourceExecutor.mapBallerinaTypes(fieldTypeNode.typeKind.typeName());
        } else if (!(node instanceof BLangConstrainedType)) {
            if (node instanceof BLangErrorType) {
                BLangErrorType fieldTypeNode = (BLangErrorType)node;
                BType bErrorType = fieldTypeNode.type;
                if (bErrorType instanceof BErrorType) {
                    property = CreateBallerinaServiceResourceExecutor.mapBallerinaTypes(((BErrorType)bErrorType).getReasonType().getKind().typeName());
                }
            } else if (!(node instanceof BLangFiniteTypeNode || node instanceof BLangFunctionTypeNode || node instanceof BLangObjectTypeNode || node instanceof BLangRecordTypeNode || node instanceof BLangStructureTypeNode || node instanceof BLangTupleTypeNode || node instanceof BLangUnionTypeNode)) {
                if (node instanceof BLangUserDefinedType) {
                    BLangUserDefinedType fieldTypeNode = (BLangUserDefinedType)node;
                    property = CreateBallerinaServiceResourceExecutor.mapBallerinaTypes(fieldTypeNode.getTypeName().value);
                } else if (node instanceof BLangValueType) {
                    BLangValueType fieldTypeNode = (BLangValueType)node;
                    property = CreateBallerinaServiceResourceExecutor.mapBallerinaTypes(fieldTypeNode.getTypeKind().typeName());
                }
            }
        }
        return property;
    }

    public static Property mapBallerinaTypes(String type) {
        switch (type) {
            case "any": {
                return null;
            }
            case "int": {
                return new IntegerProperty();
            }
            case "string": {
                return new StringProperty();
            }
            case "boolean": {
                return new BooleanProperty();
            }
            case "decimal": {
                return new DecimalProperty();
            }
            case "byte": {
                return new ByteArrayProperty();
            }
            case "float": {
                return new FloatProperty();
            }
            case "json": {
                return new ObjectProperty();
            }
        }
        return null;
    }

    private static void writeFile(Path path, String content) throws IOException {
        Path parentPath = path.getParent();
        if (null != parentPath && Files.exists(parentPath, new LinkOption[0])) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.deleteIfExists(path);
        Files.createFile(path, new FileAttribute[0]);
        try (PrintWriter writer = new PrintWriter(path.toString(), "UTF-8");){
            writer.print(content);
        }
    }

    public String getCommand() {
        return COMMAND;
    }
}

