/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

public class AnnotationConfigsProcessor {
    public static void visitAnnotation(BLangAnnotationAttachment annotation, BiConsumer<BLangRecordLiteral.BLangRecordKeyValueField, BLangSimpleVarRef> acceptor) {
        if (annotation.expr instanceof BLangRecordLiteral) {
            BLangRecordLiteral record = (BLangRecordLiteral)annotation.expr;
            for (RecordLiteralNode.RecordField field : record.fields) {
                if (!field.isKeyValueField()) continue;
                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangRecordLiteral.BLangRecordKey key = keyValue.key;
                if (!(key.expr instanceof BLangSimpleVarRef)) continue;
                acceptor.accept(keyValue, (BLangSimpleVarRef)key.expr);
            }
        }
    }

    public static void visitRecords(List<RecordLiteralNode.RecordField> fields, BiConsumer<BLangExpression, BLangSimpleVarRef> acceptor) {
        for (RecordLiteralNode.RecordField field : fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangRecordLiteral.BLangRecordKey key = keyValue.key;
                if (!(key.expr instanceof BLangSimpleVarRef)) continue;
                BLangSimpleVarRef varRef = (BLangSimpleVarRef)key.expr;
                acceptor.accept(keyValue.valueExpr, varRef);
                continue;
            }
            BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
            acceptor.accept((BLangExpression)varNameField, (BLangSimpleVarRef)varNameField);
        }
    }

    public static Optional<String> searchStringField(String fieldName, BLangAnnotationAttachment annotation) {
        String[] fieldValue = new String[]{null};
        AnnotationConfigsProcessor.visitAnnotation(annotation, (keyValue, varRef) -> {
            String variableName = varRef.variableName.value;
            if (fieldName.equalsIgnoreCase(variableName) && keyValue.valueExpr instanceof BLangLiteral) {
                fieldValue[0] = String.valueOf(((BLangLiteral)keyValue.valueExpr).value);
            }
        });
        return Optional.ofNullable(fieldValue[0]);
    }

    public static List<String> searchArrayField(String fieldName, BLangAnnotationAttachment annotation) {
        ArrayList<String> fieldValsList = new ArrayList<String>();
        AnnotationConfigsProcessor.visitAnnotation(annotation, (keyValue, varRef) -> {
            String variableName = varRef.variableName.value;
            if (fieldName.equalsIgnoreCase(variableName) && keyValue.valueExpr instanceof BLangListConstructorExpr.BLangArrayLiteral) {
                BLangListConstructorExpr.BLangArrayLiteral values = (BLangListConstructorExpr.BLangArrayLiteral)keyValue.valueExpr;
                List arr = values.exprs;
                for (BLangExpression exp : arr) {
                    if (!(exp instanceof BLangLiteral)) continue;
                    fieldValsList.add(String.valueOf(((BLangLiteral)exp).value));
                }
            }
        });
        return fieldValsList;
    }

    public static Optional<String> searchStringField(String fieldName, BLangRecordLiteral record) {
        Optional<Object> field = AnnotationConfigsProcessor.searchArrayField(fieldName, record);
        return field.map(String::valueOf);
    }

    public static Optional<Object> searchArrayField(String fieldName, BLangRecordLiteral record) {
        Object[] fieldValue = new Object[]{null};
        AnnotationConfigsProcessor.visitRecords(record.fields, (expression, varRef) -> {
            String variableName = varRef.variableName.value;
            if (fieldName.equalsIgnoreCase(variableName)) {
                fieldValue[0] = expression;
            }
        });
        return Optional.ofNullable(fieldValue[0]);
    }

    public static boolean isRecordValueExists(String fieldName, BLangRecordLiteral record) {
        boolean[] fieldValue = new boolean[]{false};
        AnnotationConfigsProcessor.visitRecords(record.fields, (expression, varRef) -> {
            String variableName = varRef.variableName.value;
            if (fieldName.equalsIgnoreCase(variableName)) {
                fieldValue[0] = true;
            }
        });
        return fieldValue[0];
    }
}

