/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.ballerinalang.langserver.command.testgen.TestGenerator;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;

public class ValueSpaceGenerator {
    public static final String PLACE_HOLDER = "{%1}";
    public static final int RANDOM_WORDS_LENGTH = 3;

    public static String[] getValueSpaceByNode(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BLangNode bLangNode, String[] template) {
        if (bLangNode.type == null && bLangNode instanceof BLangTupleDestructure) {
            List varRefs = ((BLangTupleDestructure)bLangNode).getVariableRefs();
            String[][] list = new String[varRefs.size()][template.length];
            IntStream.range(0, varRefs.size()).forEach(j -> {
                BLangExpression bLangExpression = (BLangExpression)varRefs.get(j);
                if (bLangExpression.type != null) {
                    String[] values = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, bLangExpression.type, ValueSpaceGenerator.createTemplateArray(template.length));
                    IntStream.range(0, values.length).forEach(i -> {
                        list[i][j] = values[i];
                    });
                }
            });
            IntStream.range(0, template.length).forEach(index -> {
                template[index] = template[index].replace(PLACE_HOLDER, "(" + String.join((CharSequence)", ", list[index]) + ")");
            });
            return template;
        }
        if (bLangNode instanceof BLangLiteral) {
            return (String[])Stream.of(template).map(s -> s.replace(PLACE_HOLDER, ((BLangLiteral)bLangNode).getValue().toString())).toArray();
        }
        if (bLangNode instanceof BLangAssignment) {
            return (String[])Stream.of(template).map(s -> s.replace(PLACE_HOLDER, "0")).toArray();
        }
        if (bLangNode instanceof BLangFunctionTypeNode) {
            BLangFunctionTypeNode funcType = (BLangFunctionTypeNode)bLangNode;
            TestGenerator.TestFunctionGenerator generator = new TestGenerator.TestFunctionGenerator(importsAcceptor, currentPkgId, funcType);
            StringJoiner params = new StringJoiner(", ");
            String[][] valueSpace = generator.getValueSpace();
            String[] typeSpace = generator.getTypeSpace();
            String[] nameSpace = generator.getNamesSpace();
            IntStream.range(0, typeSpace.length - 1).forEach(index -> {
                String type = typeSpace[index];
                String name = nameSpace[index];
                params.add(type + " " + name);
            });
            String returnType = "(" + typeSpace[typeSpace.length - 1] + ")";
            IntStream.range(0, template.length).forEach(index -> {
                String builder = "function (" + params.toString() + ") returns " + returnType + "{ " + (valueSpace != null ? "return " + valueSpace[index][funcType.params.size()] : "") + "; }";
                template[index] = template[index].replace(PLACE_HOLDER, builder);
            });
            return template;
        }
        return bLangNode.type != null ? ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, bLangNode.type, template) : template;
    }

    public static String[] getValueSpaceByType(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BType bType, String[] template) {
        if ((bType.tsymbol == null || bType.tsymbol.name.value.isEmpty()) && bType instanceof BArrayType) {
            BArrayType bArrayType = (BArrayType)bType;
            String[] values = ValueSpaceGenerator.getValueSpaceByTypeSymbol(bArrayType.eType.tsymbol, ValueSpaceGenerator.createTemplateArray(template.length));
            IntStream.range(0, template.length).forEach(index -> {
                template[index] = template[index].replace(PLACE_HOLDER, "[" + values[index] + "]");
            });
            return template;
        }
        if (bType instanceof BFiniteType) {
            BFiniteType bFiniteType = (BFiniteType)bType;
            Set valueSpace = bFiniteType.getValueSpace();
            if (!valueSpace.isEmpty()) {
                return ValueSpaceGenerator.getValueSpaceByNode(importsAcceptor, currentPkgId, (BLangNode)valueSpace.stream().findFirst().get(), template);
            }
        } else {
            if (bType instanceof BMapType && ((BMapType)bType).constraint != null) {
                BType constraintType = ((BMapType)bType).constraint;
                String[] values = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, constraintType, ValueSpaceGenerator.createTemplateArray(template.length));
                IntStream.range(0, template.length).forEach(index -> {
                    template[index] = template[index].replace(PLACE_HOLDER, "{key: " + values[index] + "}");
                });
                return template;
            }
            if (bType instanceof BUnionType) {
                BUnionType bUnionType = (BUnionType)bType;
                Set memberTypes = bUnionType.getMemberTypes();
                if (!memberTypes.isEmpty()) {
                    return ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, (BType)memberTypes.stream().findFirst().get(), template);
                }
            } else {
                if (bType instanceof BTupleType) {
                    BTupleType bTupleType = (BTupleType)bType;
                    List tupleTypes = bTupleType.tupleTypes;
                    String[][] vSpace = new String[template.length][tupleTypes.size()];
                    IntStream.range(0, tupleTypes.size()).forEach(j -> {
                        BType type = (BType)tupleTypes.get(j);
                        String[] values = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, type, ValueSpaceGenerator.createTemplateArray(template.length));
                        IntStream.range(0, values.length).forEach(i -> {
                            vSpace[i][j] = values[i];
                        });
                    });
                    IntStream.range(0, template.length).forEach(index -> {
                        template[index] = template[index].replace(PLACE_HOLDER, "(" + String.join((CharSequence)", ", vSpace[index]) + ")");
                    });
                    return template;
                }
                if (bType instanceof BRecordType) {
                    BRecordType bRecordType = (BRecordType)bType;
                    List params = bRecordType.fields;
                    String[][] list = new String[template.length][params.size()];
                    IntStream.range(0, params.size()).forEach(paramIndex -> {
                        BField field = (BField)params.get(paramIndex);
                        String[] values = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, field.type, ValueSpaceGenerator.createTemplateArray(template.length));
                        IntStream.range(0, values.length).forEach(valIndex -> {
                            list[valIndex][paramIndex] = field.name + ": " + values[valIndex];
                        });
                    });
                    IntStream.range(0, template.length).forEach(index -> {
                        String paramsStr = String.join((CharSequence)", ", list[index]);
                        String newObjStr = "{" + paramsStr + "}";
                        template[index] = template[index].replace(PLACE_HOLDER, newObjStr);
                    });
                    return template;
                }
                if (bType instanceof BObjectType && ((BObjectType)bType).tsymbol instanceof BObjectTypeSymbol) {
                    BObjectTypeSymbol bStructSymbol = (BObjectTypeSymbol)((BObjectType)bType).tsymbol;
                    List params = bStructSymbol.initializerFunc.symbol.params;
                    String[][] list = new String[template.length][params.size()];
                    IntStream.range(0, params.size()).forEach(paramIndex -> {
                        BVarSymbol param = (BVarSymbol)params.get(paramIndex);
                        String[] values = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, param.type, ValueSpaceGenerator.createTemplateArray(template.length));
                        IntStream.range(0, values.length).forEach(valIndex -> {
                            list[valIndex][paramIndex] = values[valIndex];
                        });
                    });
                    IntStream.range(0, template.length).forEach(index -> {
                        String pkgPrefix = CommonUtil.getPackagePrefix(importsAcceptor, currentPkgId, bStructSymbol.pkgID);
                        String paramsStr = String.join((CharSequence)", ", list[index]);
                        String newObjStr = "new " + pkgPrefix + bStructSymbol.name.getValue() + "(" + paramsStr + ")";
                        template[index] = template[index].replace(PLACE_HOLDER, newObjStr);
                    });
                    return template;
                }
                if (bType instanceof BInvokableType) {
                    BInvokableType invokableType = (BInvokableType)bType;
                    TestGenerator.TestFunctionGenerator generator = new TestGenerator.TestFunctionGenerator(importsAcceptor, currentPkgId, invokableType);
                    StringJoiner params = new StringJoiner(", ");
                    String[][] valueSpace = generator.getValueSpace();
                    String[] typeSpace = generator.getTypeSpace();
                    String[] nameSpace = generator.getNamesSpace();
                    IntStream.range(0, typeSpace.length - 1).forEach(index -> {
                        String type = typeSpace[index];
                        String name = nameSpace[index];
                        params.add(type + " " + name);
                    });
                    String returnType = "(" + typeSpace[typeSpace.length - 1] + ")";
                    IntStream.range(0, template.length).forEach(index -> {
                        String functionStr = "function (" + params.toString() + ") returns " + returnType + "{ " + (valueSpace != null ? "return " + valueSpace[index][invokableType.paramTypes.size()] : "") + "; }";
                        template[index] = template[index].replace(PLACE_HOLDER, functionStr);
                    });
                    return template;
                }
            }
        }
        return bType.tsymbol != null ? ValueSpaceGenerator.getValueSpaceByTypeSymbol(bType.tsymbol, template) : (String[])Stream.of(template).map(s -> s.replace(PLACE_HOLDER, "()")).toArray();
    }

    public static String[] getValueSpaceByTypeSymbol(BTypeSymbol tSymbol, String[] template) {
        if (tSymbol == null) {
            String[] result = new String[]{"()"};
            ValueSpaceGenerator.populateValueSpace(result, template, () -> "()");
            return template;
        }
        Random random = new Random();
        switch (tSymbol.name.getValue()) {
            case "int": 
            case "any": {
                String[] resultInt = new String[]{"-1", "0", "1"};
                ValueSpaceGenerator.populateValueSpace(resultInt, template, () -> String.valueOf(random.nextInt(template.length)));
                break;
            }
            case "string": {
                String[] resultStr = new String[]{"\"\"", "\"foo\"", "\"bar\""};
                ValueSpaceGenerator.populateValueSpace(resultStr, template, () -> "\"" + RandomStringUtils.randomAlphabetic((int)3) + "\"");
                break;
            }
            case "float": {
                String[] resultFloat = new String[]{"-1.0", "0.0", "1.0"};
                ValueSpaceGenerator.populateValueSpace(resultFloat, template, () -> String.format("%.1f", random.nextDouble()));
                break;
            }
            case "json": {
                String[] resultJson = new String[]{"{\"key\": \"value\"}", "{}", "{\"foo\": \"bar\"}"};
                ValueSpaceGenerator.populateValueSpace(resultJson, template, () -> {
                    String key = RandomStringUtils.randomAlphabetic((int)3);
                    String value = RandomStringUtils.randomAlphabetic((int)3);
                    return "{\"" + key + "\": \"" + value + "\"}";
                });
                break;
            }
            case "boolean": {
                String[] resultBool = new String[]{"false", "true"};
                ValueSpaceGenerator.populateValueSpace(resultBool, template, () -> String.valueOf(random.nextBoolean()));
                break;
            }
            case "xml": {
                String[] resultXml = new String[]{"xml `<msg>hello</msg>`", "xml `<foo>bar</foo>`", "xml `<bar>foo</bar>`"};
                ValueSpaceGenerator.populateValueSpace(resultXml, template, () -> {
                    String key = RandomStringUtils.randomAlphabetic((int)3);
                    String value = RandomStringUtils.randomAlphabetic((int)3);
                    return "xml `<" + key + ">" + value + "</" + key + ">`";
                });
                break;
            }
            case "byte": {
                String[] resultBlob = new String[]{"0"};
                ValueSpaceGenerator.populateValueSpace(resultBlob, template, () -> String.valueOf("0"));
                break;
            }
            case "error": {
                String[] resultErr = new String[]{"error(\"\")"};
                String msg = RandomStringUtils.randomAlphabetic((int)3);
                ValueSpaceGenerator.populateValueSpace(resultErr, template, () -> "error(\"" + msg + "\")");
                break;
            }
            default: {
                String[] result = new String[]{"()"};
                ValueSpaceGenerator.populateValueSpace(result, template, () -> "()");
            }
        }
        return template;
    }

    public static void populateValueSpace(String[] definedSpace, String[] template, Supplier<String> random) {
        int min = Math.min(definedSpace.length, template.length);
        IntStream.range(0, min).forEach(i -> {
            template[i] = template[i].replace(PLACE_HOLDER, definedSpace[i]);
        });
        int max = Math.max(min, template.length);
        IntStream.range(0, max).forEach(index -> {
            template[index] = template[index].replace(PLACE_HOLDER, (CharSequence)random.get());
        });
    }

    public static String[] createTemplateArray(int length) {
        Object[] templates = new String[length];
        Arrays.fill(templates, PLACE_HOLDER);
        return templates;
    }
}

