/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.ballerinalang.langserver.command.testgen.AnnotationConfigsProcessor;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.renderer.TemplateBasedRendererOutput;
import org.ballerinalang.langserver.command.testgen.template.AbstractTestTemplate;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;

public class HttpResourceTemplate
extends AbstractTestTemplate {
    private final List<String[]> resourceMethods;
    private final String resourcePath;
    private final String serviceUriStrName;
    private final String httpEndpoint;

    public HttpResourceTemplate(String serviceUriStrName, String basePath, BLangFunction resource, String httpEndpoint) {
        super(null, null);
        this.httpEndpoint = httpEndpoint;
        this.serviceUriStrName = serviceUriStrName;
        this.resourceMethods = new ArrayList<String[]>();
        String resourceName = resource.name.value;
        this.resourceMethods.add(new String[]{resourceName, "get"});
        String tempResourcePath = basePath + "/" + resourceName;
        List annAttachments = resource.annAttachments;
        if (annAttachments.size() > 0) {
            for (BLangAnnotationAttachment annotation : annAttachments) {
                List<String> methods = AnnotationConfigsProcessor.searchArrayField("methods", annotation);
                if (!methods.isEmpty()) {
                    this.resourceMethods.clear();
                    methods.forEach(resourceMethod -> this.resourceMethods.add(new String[]{resourceName, resourceMethod}));
                }
                Optional<String> annotPath = AnnotationConfigsProcessor.searchStringField("path", annotation);
                tempResourcePath = basePath + annotPath.filter(path -> !"/".equals(path)).orElse("");
            }
        }
        this.resourcePath = tempResourcePath = tempResourcePath.replaceAll("[{}]", "");
    }

    @Override
    public void render(RendererOutput rendererOutput) throws TestGeneratorException {
        StringBuilder methods = new StringBuilder();
        for (String[] method : this.resourceMethods) {
            String resourceName = method[0];
            String resourceMethod = method[1].toLowerCase(Locale.getDefault());
            String resourceMethodAllCaps = resourceMethod.toUpperCase(Locale.getDefault());
            String responseFieldMethodName = this.resourceMethods.size() > 1 ? HttpResourceTemplate.upperCaseFirstLetter(resourceMethod) : "";
            String responseFieldName = HttpResourceTemplate.lowerCaseFirstLetter(resourceName) + responseFieldMethodName + "Response";
            String additionalParams = "";
            if (!"get".equals(resourceMethod) && !"head".equals(resourceMethod)) {
                additionalParams = ",\"\"";
            }
            TemplateBasedRendererOutput resourceOutput = new TemplateBasedRendererOutput("httpResource.bal");
            resourceOutput.put(PlaceHolder.OTHER.get("resourceMethodAllCaps"), resourceMethodAllCaps);
            resourceOutput.put(PlaceHolder.OTHER.get("responseFieldName"), responseFieldName);
            resourceOutput.put(PlaceHolder.OTHER.get("resourceMethod"), resourceMethod);
            resourceOutput.put(PlaceHolder.OTHER.get("resourcePath"), this.resourcePath);
            resourceOutput.put(PlaceHolder.OTHER.get("additionalParams"), additionalParams);
            resourceOutput.put(PlaceHolder.OTHER.get("serviceUriStrName"), this.serviceUriStrName);
            resourceOutput.put(PlaceHolder.OTHER.get("endpointName"), this.httpEndpoint);
            methods.append(resourceOutput.getRenderedContent());
        }
        rendererOutput.append(PlaceHolder.OTHER.get("resources"), methods.toString());
    }
}

