/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;

public final class BFunctionCompletionItemBuilder {
    private BFunctionCompletionItemBuilder() {
    }

    public static CompletionItem build(BInvokableSymbol bSymbol, String label, String insertText, LSContext context) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setInsertText(insertText);
        BFunctionCompletionItemBuilder.setMeta(item, bSymbol, context);
        return item;
    }

    public static CompletionItem build(BInvokableSymbol bSymbol, LSContext context) {
        CompletionItem item = new CompletionItem();
        BFunctionCompletionItemBuilder.setMeta(item, bSymbol, context);
        if (bSymbol != null) {
            String functionName = CommonUtil.getFunctionNameFromSymbol(bSymbol);
            Pair<String, String> functionSignature = CommonUtil.getFunctionInvocationSignature(bSymbol, functionName, context);
            item.setInsertText((String)functionSignature.getLeft());
            item.setLabel((String)functionSignature.getRight());
        }
        return item;
    }

    private static void setMeta(CompletionItem item, BInvokableSymbol bSymbol, LSContext ctx) {
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setDetail("Function");
        item.setKind(CompletionItemKind.Function);
        if (bSymbol != null) {
            List<String> funcArguments = FunctionGenerator.getFuncArguments(bSymbol, ctx);
            if (!funcArguments.isEmpty()) {
                Command cmd = new Command("editor.action.triggerParameterHints", "editor.action.triggerParameterHints");
                item.setCommand(cmd);
            }
            int invocationType = ctx == null || ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY) == null ? -1 : (Integer)ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
            boolean skipFirstParam = CommonUtil.skipFirstParam(bSymbol, invocationType);
            if (bSymbol.markdownDocumentation != null) {
                item.setDocumentation(BFunctionCompletionItemBuilder.getDocumentation(bSymbol, skipFirstParam, ctx));
            }
        }
    }

    private static Either<String, MarkupContent> getDocumentation(BInvokableSymbol bInvokableSymbol, boolean skipFirstParam, LSContext ctx) {
        String pkgID = bInvokableSymbol.pkgID.toString();
        MarkdownDocAttachment docAttachment = bInvokableSymbol.getMarkdownDocAttachment();
        String description = docAttachment.description == null ? "" : docAttachment.description;
        HashMap<String, String> docParamsMap = new HashMap<String, String>();
        for (MarkdownDocAttachment.Parameter parameter : docAttachment.parameters) {
            docParamsMap.put(parameter.name, parameter.description);
        }
        List defaultParams = bInvokableSymbol.getParameters().stream().filter(varSymbol -> varSymbol.defaultableParam).collect(Collectors.toList());
        MarkupContent docMarkupContent = new MarkupContent();
        docMarkupContent.setKind("markdown");
        String documentation = "**Package:** _" + pkgID + "_" + CommonUtil.MD_LINE_SEPARATOR + CommonUtil.MD_LINE_SEPARATOR + description + CommonUtil.MD_LINE_SEPARATOR;
        StringJoiner joiner = new StringJoiner(CommonUtil.MD_LINE_SEPARATOR);
        ArrayList<BVarSymbol> functionParameters = new ArrayList<BVarSymbol>(bInvokableSymbol.params);
        if (bInvokableSymbol.restParam != null) {
            functionParameters.add(bInvokableSymbol.restParam);
        }
        for (int i = 0; i < functionParameters.size(); ++i) {
            BVarSymbol paramSymbol = (BVarSymbol)functionParameters.get(i);
            String paramType = CommonUtil.getBTypeName(paramSymbol.type, ctx, false);
            if (i == 0 && skipFirstParam) continue;
            Optional<BVarSymbol> defaultVal = defaultParams.stream().filter(bVarSymbol -> bVarSymbol.getName().getValue().equals(paramSymbol.name.value)).findFirst();
            String paramDescription = "- `" + paramType + "` " + paramSymbol.getName().getValue();
            if (docParamsMap.containsKey(paramSymbol.name.value)) {
                paramDescription = paramDescription + ": " + (String)docParamsMap.get(paramSymbol.name.value);
            }
            if (defaultVal.isPresent()) {
                joiner.add(paramDescription + "(Defaultable)");
                continue;
            }
            joiner.add(paramDescription);
        }
        String paramsStr = joiner.toString();
        if (!paramsStr.isEmpty()) {
            documentation = documentation + "**Params**" + CommonUtil.MD_LINE_SEPARATOR + paramsStr;
        }
        if (!(bInvokableSymbol.retType instanceof BNilType) && bInvokableSymbol.retType != null && bInvokableSymbol.retType.tsymbol != null) {
            String desc = "";
            if (docAttachment.returnValueDescription != null && !docAttachment.returnValueDescription.isEmpty()) {
                desc = "- " + CommonUtil.MD_NEW_LINE_PATTERN.matcher(docAttachment.returnValueDescription).replaceAll(CommonUtil.MD_LINE_SEPARATOR) + CommonUtil.MD_LINE_SEPARATOR;
            }
            documentation = documentation + CommonUtil.MD_LINE_SEPARATOR + CommonUtil.MD_LINE_SEPARATOR + "**Returns** `" + CommonUtil.getBTypeName(bInvokableSymbol.retType, ctx, false) + "` " + CommonUtil.MD_LINE_SEPARATOR + desc + CommonUtil.MD_LINE_SEPARATOR;
        }
        docMarkupContent.setValue(documentation);
        return Either.forRight((Object)docMarkupContent);
    }
}

