/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.LSAnnotationCache;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.AnnotationNodeKind;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.Name;

public class AnnotationAttachmentContextProvider
extends AbstractCompletionProvider {
    public AnnotationAttachmentContextProvider() {
        this.attachmentPoints.add(AnnotationAttachmentContextProvider.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        List rhsTokenTypes = (List)ctx.get(SourcePruneKeys.RHS_DEFAULT_TOKEN_TYPES_KEY);
        AnnotationNodeKind annotationNodeKind = (AnnotationNodeKind)ctx.get(CompletionKeys.NEXT_NODE_KEY);
        if (annotationNodeKind == null && rhsTokenTypes.contains(5)) {
            annotationNodeKind = AnnotationNodeKind.EXTERNAL;
        } else if (annotationNodeKind == null) {
            return new ArrayList<LSCompletionItem>();
        }
        return this.filterAnnotations(annotationNodeKind, ctx);
    }

    private List<LSCompletionItem> filterAnnotations(AnnotationNodeKind attachmentPoint, LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List lhsTokenTypes = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        List lhsDefaultTokens = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        Map<String, String> pkgAliasMap = ((List)ctx.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY)).stream().collect(Collectors.toMap(pkg -> pkg.symbol.pkgID.toString(), pkg -> pkg.alias.value));
        CommonToken pkgAlias = null;
        if (lhsTokenTypes == null) {
            return completionItems;
        }
        int atTokenIndex = lhsTokenTypes.indexOf(131);
        int colonTokenIndex = lhsTokenTypes.indexOf(96);
        if (atTokenIndex == -1) {
            return completionItems;
        }
        if (colonTokenIndex > 0) {
            pkgAlias = (CommonToken)lhsDefaultTokens.get(colonTokenIndex - 1);
        }
        CommonToken finalAlias = pkgAlias;
        LSAnnotationCache.getInstance().getAnnotationMapForType(attachmentPoint, ctx).forEach((key, value) -> value.forEach(annotation -> {
            String annotationPkgAlias = ((Name)annotation.pkgID.nameComps.get((int)(annotation.pkgID.nameComps.size() - 1))).value;
            String annotationPkg = annotation.pkgID.toString();
            if (finalAlias == null || finalAlias.getText().equals(annotationPkgAlias) || finalAlias.getText().equals(pkgAliasMap.get(annotationPkg))) {
                completionItems.add(CommonUtil.getAnnotationCompletionItem(key, annotation, ctx, finalAlias, pkgAliasMap));
            }
        }));
        completionItems.addAll(this.getAnnotationsInModule(ctx, attachmentPoint, pkgAliasMap));
        return completionItems;
    }

    private List<LSCompletionItem> getAnnotationsInModule(LSContext ctx, AnnotationNodeKind kind, Map<String, String> pkgAliasMap) {
        BLangPackage bLangPackage = (BLangPackage)ctx.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<BLangAnnotation> annotations = bLangPackage.topLevelNodes.stream().filter(topLevelNode -> topLevelNode instanceof BLangAnnotation).map(topLevelNode -> (BLangAnnotation)topLevelNode).collect(Collectors.toList());
        BLangNode scopeNode = (BLangNode)ctx.get(CompletionKeys.SCOPE_NODE_KEY);
        annotations.forEach(bLangAnnotation -> {
            BAnnotationSymbol symbol = (BAnnotationSymbol)bLangAnnotation.symbol;
            PackageID pkgId = symbol.pkgID;
            int maskedPoints = symbol.maskedPoints;
            switch (kind) {
                case ANNOTATION: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)4096)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case FUNCTION: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)4) && (!Symbols.isAttachPointPresent((int)maskedPoints, (int)8) || scopeNode.getKind() != NodeKind.OBJECT_TYPE)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case LISTENER: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)2048)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case OBJECT: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)1) && !Symbols.isAttachPointPresent((int)maskedPoints, (int)2)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case RESOURCE: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)16) && !Symbols.isAttachPointPresent((int)maskedPoints, (int)4)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case SERVICE: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)128)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case RECORD: 
                case TYPE: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)1)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
                case WORKER: {
                    if (!Symbols.isAttachPointPresent((int)maskedPoints, (int)65536)) break;
                    completionItems.add(CommonUtil.getAnnotationCompletionItem(pkgId, symbol, ctx, pkgAliasMap));
                    break;
                }
            }
        });
        return completionItems;
    }
}

