/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;

public class IfWhileConditionContextProvider
extends AbstractCompletionProvider {
    public IfWhileConditionContextProvider() {
        this.attachmentPoints.add(IfWhileConditionContextProvider.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext context) {
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        if (lhsTokens == null) {
            return this.getExpressionCompletions(context, visibleSymbols);
        }
        List lhsDefaultTokens = lhsTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        List<Integer> tokenTypes = lhsDefaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList());
        visibleSymbols.removeIf(CommonUtil.invalidSymbolsPredicate());
        boolean isTypeGuardCondition = this.isTypeGuardCondition(tokenTypes);
        int invocationOrDelimiterTokenType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if (invocationOrDelimiterTokenType > -1) {
            if (invocationOrDelimiterTokenType == 96 && isTypeGuardCondition) {
                String pkgName = ((CommonToken)lhsDefaultTokens.get(tokenTypes.indexOf(invocationOrDelimiterTokenType) - 1)).getText();
                return this.getTypeItemsInPackage(visibleSymbols, pkgName, context);
            }
            Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> items = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
            return this.getCompletionItemList(items, context);
        }
        if (isTypeGuardCondition) {
            List<LSCompletionItem> typeItems = this.getPackagesCompletionItems(context);
            List<Scope.ScopeEntry> userDefinedTypes = visibleSymbols.stream().filter(scopeEntry -> scopeEntry.symbol instanceof BTypeSymbol && !(scopeEntry.symbol instanceof BPackageSymbol)).collect(Collectors.toList());
            typeItems.addAll(this.getCompletionItemList(userDefinedTypes, context));
            return typeItems;
        }
        return this.getExpressionCompletions(context, visibleSymbols);
    }

    private boolean isTypeGuardCondition(List<Integer> tokenTypes) {
        return tokenTypes.contains(84);
    }

    private List<LSCompletionItem> getExpressionCompletions(LSContext context, List<Scope.ScopeEntry> visibleSymbols) {
        List<LSCompletionItem> completionItems = this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(visibleSymbols), context);
        completionItems.addAll(this.getPackagesCompletionItems(context));
        return completionItems;
    }
}

