/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;

public class ServiceDefinitionContextProvider
extends AbstractCompletionProvider {
    public ServiceDefinitionContextProvider() {
        this.attachmentPoints.add(BallerinaParser.ServiceDefinitionContext.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        List lhsDefaultTokens = lhsTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        int startIndex = lhsDefaultTokens.size() - 1;
        block8: while (true) {
            if (startIndex < 0) {
                return completionItems;
            }
            CommonToken token = (CommonToken)lhsDefaultTokens.get(startIndex);
            int tokenType = token.getType();
            switch (tokenType) {
                case 7: 
                case 27: 
                case 48: 
                case 96: {
                    break block8;
                }
                default: {
                    --startIndex;
                    continue block8;
                }
            }
            break;
        }
        switch (((CommonToken)lhsDefaultTokens.get(startIndex)).getType()) {
            case 27: {
                completionItems.addAll(this.getCompletionItemsAfterOnKeyword(context));
                break;
            }
            case 48: {
                ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
                List<Scope.ScopeEntry> filteredSymbols = this.filterListenerTypes(visibleSymbols);
                completionItems.addAll(this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(filteredSymbols), context));
                completionItems.addAll(this.getPackagesCompletionItems(context));
                break;
            }
            case 96: {
                List<Scope.ScopeEntry> listeners = this.filterListenersFromPackage(context);
                completionItems.addAll(this.getCompletionItemList(listeners, context));
                break;
            }
            default: {
                completionItems.add(new SnippetCompletionItem(context, Snippet.KW_ON.get()));
            }
        }
        return completionItems;
    }

    private List<Scope.ScopeEntry> filterListenerTypes(List<Scope.ScopeEntry> scopeEntries) {
        return scopeEntries.stream().filter(scopeEntry -> CommonUtil.isListenerObject(scopeEntry.symbol)).collect(Collectors.toList());
    }

    private List<Scope.ScopeEntry> filterListenersFromPackage(LSContext context) {
        List defaultTokens = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        List tokenTypes = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        if (tokenTypes == null) {
            return new ArrayList<Scope.ScopeEntry>();
        }
        int colonIndex = tokenTypes.indexOf(96);
        if (colonIndex < 0) {
            return new ArrayList<Scope.ScopeEntry>();
        }
        String pkgName = ((CommonToken)defaultTokens.get(colonIndex - 1)).getText();
        Optional<Scope.ScopeEntry> symbolWithName = visibleSymbols.stream().filter(scopeEntry -> scopeEntry.symbol.name.getValue().equals(pkgName)).findAny();
        if (!symbolWithName.isPresent() || !(symbolWithName.get().symbol instanceof BPackageSymbol)) {
            return new ArrayList<Scope.ScopeEntry>();
        }
        BPackageSymbol pkgSymbol = (BPackageSymbol)symbolWithName.get().symbol;
        return pkgSymbol.scope.entries.values().stream().filter(scopeEntry -> CommonUtil.isListenerObject(scopeEntry.symbol)).collect(Collectors.toList());
    }
}

