/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.sourceprune;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.sourceprune.AbstractTokenTraverser;
import org.ballerinalang.langserver.sourceprune.SourcePruneContext;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;

class RHSCompletionsTokenTraverser
extends AbstractTokenTraverser {
    private int leftBraceCount;
    private int leftBracketCount;
    private int leftParenthesisCount;
    private int ltTokenCount;
    private List<Integer> rhsTraverseTerminals;
    private boolean definitionRemoved;
    private boolean forcedProcessedToken;

    RHSCompletionsTokenTraverser(SourcePruneContext sourcePruneContext, boolean pruneTokens) {
        super(pruneTokens);
        this.leftBraceCount = sourcePruneContext.get(SourcePruneKeys.LEFT_BRACE_COUNT_KEY);
        this.leftParenthesisCount = sourcePruneContext.get(SourcePruneKeys.LEFT_PARAN_COUNT_KEY);
        this.leftBracketCount = sourcePruneContext.get(SourcePruneKeys.LEFT_BRACKET_COUNT_KEY);
        this.ltTokenCount = sourcePruneContext.get(SourcePruneKeys.LT_COUNT_KEY);
        this.rhsTraverseTerminals = sourcePruneContext.get(SourcePruneKeys.RHS_TRAVERSE_TERMINALS_KEY);
        this.definitionRemoved = sourcePruneContext.get(SourcePruneKeys.REMOVE_DEFINITION_KEY);
        this.forcedProcessedToken = false;
        this.processedTokens = new ArrayList();
    }

    @Override
    public List<CommonToken> traverse(TokenStream tokenStream, int tokenIndex) {
        Optional<Object> token = Optional.of(tokenStream.get(tokenIndex));
        while (token.isPresent()) {
            int type = token.get().getType();
            if (100 == type && this.leftBraceCount > 0) {
                --this.leftBraceCount;
            } else if (99 == type && this.definitionRemoved) {
                ++this.leftBraceCount;
            } else if (101 == type) {
                ++this.leftParenthesisCount;
            } else if (this.rhsTraverseTerminals.contains(type)) {
                boolean terminateRHSTraverse = this.terminateRHSTraverse(token.get());
                if (terminateRHSTraverse) {
                    break;
                }
            } else if (103 == type) {
                ++this.leftBracketCount;
            } else if (119 == type) {
                ++this.ltTokenCount;
            }
            if (!this.forcedProcessedToken) {
                this.processToken(token.get());
            }
            this.forcedProcessedToken = false;
            tokenIndex = token.get().getTokenIndex() + 1;
            token = tokenIndex > tokenStream.size() - 1 ? Optional.empty() : Optional.of(tokenStream.get(tokenIndex));
        }
        return this.processedTokens;
    }

    private boolean terminateRHSTraverse(Token token) {
        int type = token.getType();
        if (type == 118 && this.ltTokenCount > 0) {
            --this.ltTokenCount;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 102 && this.leftParenthesisCount > 0) {
            --this.leftParenthesisCount;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 104 && this.leftBracketCount > 0) {
            --this.leftBracketCount;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 99 && this.lastProcessedToken != null && (this.lastProcessedToken.getType() == 136 || this.lastProcessedToken.getType() == 96)) {
            ++this.leftBraceCount;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 100 && this.leftBraceCount > 0) {
            --this.leftBraceCount;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (this.leftBraceCount > 0 || this.leftParenthesisCount > 0) {
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 95 || type == 98) {
            this.processToken(token);
            this.forcedProcessedToken = true;
        }
        return true;
    }
}

