/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.commons.completion.spi.LSCompletionProvider;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.LSCompletionProviderHolder;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.sourceprune.CompletionsTokenTraverserFactory;
import org.ballerinalang.langserver.completions.util.SourcePruneException;
import org.ballerinalang.langserver.completions.util.sorters.ItemSorters;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.langserver.sourceprune.SourcePruner;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertTextFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CompletionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionUtil.class);

    public static void resolveSymbols(LSContext completionContext) {
        TreeVisitor treeVisitor = new TreeVisitor(completionContext);
        BLangPackage bLangPackage = (BLangPackage)completionContext.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        bLangPackage.accept((BLangNodeVisitor)treeVisitor);
    }

    public static List<CompletionItem> getCompletionItems(LSContext ctx) {
        ArrayList<LSCompletionItem> items = new ArrayList<LSCompletionItem>();
        if (ctx == null) {
            return new ArrayList<CompletionItem>();
        }
        CompletionUtil.setInvocationOrInteractionOrFieldAccessToken(ctx);
        BLangNode scope = (BLangNode)ctx.get(CompletionKeys.SCOPE_NODE_KEY);
        Map<Class, LSCompletionProvider> scopeProviders = LSCompletionProviderHolder.getInstance().getProviders();
        LSCompletionProvider completionProvider = scopeProviders.get(scope.getClass());
        try {
            items.addAll(completionProvider.getCompletions(ctx));
        }
        catch (Exception e) {
            LOGGER.error("Error while retrieving completions from: " + completionProvider.getClass());
        }
        return CompletionUtil.getPreparedCompletionItems(ctx, items);
    }

    private static List<CompletionItem> getPreparedCompletionItems(LSContext context, List<LSCompletionItem> items) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        boolean isSnippetSupported = ((CompletionCapabilities)context.get(CompletionKeys.CLIENT_CAPABILITIES_KEY)).getCompletionItem().getSnippetSupport();
        List<CompletionItem> sortedItems = ItemSorters.get(((BLangNode)context.get(CompletionKeys.SCOPE_NODE_KEY)).getClass()).sortItems(context, items);
        for (CompletionItem item : sortedItems) {
            if (!isSnippetSupported) {
                item.setInsertText(CommonUtil.getPlainTextSnippet(item.getInsertText()));
                item.setInsertTextFormat(InsertTextFormat.PlainText);
            } else {
                item.setInsertTextFormat(InsertTextFormat.Snippet);
            }
            completionItems.add(item);
        }
        return completionItems;
    }

    private static void setInvocationOrInteractionOrFieldAccessToken(LSContext context) {
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        List<Integer> invocationTokens = Arrays.asList(96, 97, 129, 115, 106);
        context.put(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY, (Object)-1);
        if (lhsTokens == null) {
            return;
        }
        List lhsDefaultTokens = lhsTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        if (lhsDefaultTokens.isEmpty()) {
            return;
        }
        int lastToken = ((CommonToken)CommonUtil.getLastItem(lhsDefaultTokens)).getType();
        int tokenBeforeLast = lhsDefaultTokens.size() >= 2 ? ((CommonToken)lhsDefaultTokens.get(lhsDefaultTokens.size() - 2)).getType() : -1;
        int resultToken = -1;
        if (invocationTokens.contains(lastToken)) {
            resultToken = lastToken;
        } else if (lhsDefaultTokens.size() >= 2 && invocationTokens.contains(tokenBeforeLast)) {
            resultToken = tokenBeforeLast;
        }
        context.put(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY, (Object)resultToken);
    }

    public static void pruneSource(LSContext lsContext) throws SourcePruneException, WorkspaceDocumentException {
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        String uri = (String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY);
        if (uri == null) {
            throw new SourcePruneException("fileUri cannot be null!");
        }
        Path filePath = Paths.get(URI.create(uri));
        CompletionsTokenTraverserFactory tokenTraverserFactory = new CompletionsTokenTraverserFactory(filePath, documentManager, SourcePruner.newContext());
        SourcePruner.pruneSource(lsContext, tokenTraverserFactory);
        documentManager.setPrunedContent(filePath, tokenTraverserFactory.getTokenStream().getText());
    }
}

