/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.filters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.filters.AbstractSymbolFilter;
import org.ballerinalang.model.elements.Flag;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;

public class StatementTemplateFilter
extends AbstractSymbolFilter {
    @Override
    public Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filterItems(LSContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        BLangNode bLangNode = (BLangNode)context.get(CompletionKeys.SCOPE_NODE_KEY);
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_IF.get()));
        if (context.get(CompletionKeys.PREVIOUS_NODE_KEY) instanceof BLangIf) {
            completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_ELSE_IF.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_ELSE.get()));
        }
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_WHILE.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_LOCK.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_FOREACH.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_FORK.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_TRANSACTION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_MATCH.get()));
        if (bLangNode instanceof BLangBlockStmt && bLangNode.parent instanceof BLangForkJoin || bLangNode instanceof BLangFunctionBody && (!(bLangNode.parent instanceof BLangLambdaFunction) || !((BLangLambdaFunction)bLangNode.parent).function.flagSet.contains(Flag.WORKER))) {
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_WORKER.get()));
        }
        if ((Integer)context.get(CompletionKeys.LOOP_COUNT_KEY) > 0 && !((Boolean)context.get(CompletionKeys.CURRENT_NODE_TRANSACTION_KEY)).booleanValue()) {
            completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_CONTINUE.get()));
        }
        if ((Integer)context.get(CompletionKeys.LOOP_COUNT_KEY) > 0) {
            completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_BREAK.get()));
        }
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_RETURN.get()));
        if ((Integer)context.get(CompletionKeys.TRANSACTION_COUNT_KEY) > 0) {
            completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_ABORT.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_RETRY.get()));
        }
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_PANIC.get()));
        completionItems.sort(Comparator.comparing(lsCompletionItem -> lsCompletionItem.getCompletionItem().getLabel()));
        completionItems.forEach(completionItem -> completionItem.getCompletionItem().setInsertTextFormat(InsertTextFormat.Snippet));
        return Either.forLeft(completionItems);
    }
}

