/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.model.tree.Node;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ServiceScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        Position position = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        DiagnosticPos zeroBasedPo = CommonUtil.toZeroBasedPosition(nodePosition);
        int line = position.getLine();
        int col = position.getCharacter();
        int nodeSLine = zeroBasedPo.sLine;
        int nodeSCol = zeroBasedPo.sCol;
        if (line < nodeSLine || line == nodeSLine && col <= nodeSCol || this.isWithinScopeAfterLastChildNode((Node)node, treeVisitor, line, col)) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, treeVisitor.getSymbolEnv());
            treeVisitor.setNextNode(bSymbol, node);
            treeVisitor.forceTerminateVisitor();
            return true;
        }
        return false;
    }

    private boolean isWithinScopeAfterLastChildNode(Node node, TreeVisitor treeVisitor, int curLine, int curCol) {
        BLangObjectTypeNode bLangService = (BLangObjectTypeNode)treeVisitor.getBlockOwnerStack().peek();
        DiagnosticPos serviceNodePos = CommonUtil.toZeroBasedPosition(bLangService.getPosition());
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition((DiagnosticPos)node.getPosition());
        List serviceFunctions = bLangService.getFunctions();
        List serviceFields = bLangService.getFields().stream().map(simpleVar -> (BLangSimpleVariable)simpleVar).collect(Collectors.toList());
        ArrayList<Object> serviceContent = new ArrayList<Object>(serviceFunctions);
        serviceContent.addAll(serviceFields);
        serviceContent.sort(new CommonUtil.BLangNodeComparator());
        int serviceEndLine = serviceNodePos.getEndLine();
        int serviceEndCol = serviceNodePos.getEndColumn();
        int nodeEndLine = nodePos.getEndLine();
        int nodeEndCol = nodePos.getEndColumn();
        boolean isLastChildNode = !serviceContent.isEmpty() && serviceContent.indexOf(node) == serviceContent.size() - 1;
        return isLastChildNode && (curLine < serviceEndLine || curLine == serviceEndLine && curCol < serviceEndCol) && (nodeEndLine < curLine || nodeEndLine == curLine && nodeEndCol < curCol);
    }
}

