/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.compiler.common.modal.SymbolMetaInfo;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class VisibleEndpointVisitor
extends LSNodeVisitor {
    private SymbolEnv symbolEnv;
    private SymbolResolver symbolResolver;
    private SymbolTable symTable;
    private Map<BLangNode, List<SymbolMetaInfo>> visibleEPsByNode;
    private Map<PackageID, BLangImportPackage> packageMap;

    public VisibleEndpointVisitor(CompilerContext compilerContext) {
        this.symTable = SymbolTable.getInstance((CompilerContext)compilerContext);
        this.symbolResolver = SymbolResolver.getInstance((CompilerContext)compilerContext);
        this.visibleEPsByNode = new HashMap<BLangNode, List<SymbolMetaInfo>>();
        this.packageMap = new HashMap<PackageID, BLangImportPackage>();
    }

    public Map<BLangNode, List<SymbolMetaInfo>> getVisibleEPsByNode() {
        return this.visibleEPsByNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        SymbolEnv pkgEnv;
        this.symbolEnv = pkgEnv = (SymbolEnv)this.symTable.pkgEnvMap.get(pkgNode.symbol);
        List topLevelNodes = pkgNode.topLevelNodes;
        pkgNode.getImports().forEach(importPackage -> {
            if (importPackage.symbol != null) {
                this.packageMap.put(importPackage.symbol.pkgID, (BLangImportPackage)importPackage);
            }
        });
        topLevelNodes.stream().filter(CommonUtil.checkInvalidTypesDefs()).forEach(topLevelNode -> this.acceptNode((BLangNode)topLevelNode, pkgEnv));
    }

    @Override
    public void visit(BLangFunction funcNode) {
        if (funcNode.body == null) {
            return;
        }
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv((BLangFunction)funcNode, (Scope)funcNode.symbol.scope, (SymbolEnv)this.symbolEnv);
        SymbolEnv funcBodyEnv = SymbolEnv.createFuncBodyEnv((BLangFunctionBody)funcNode.body, (SymbolEnv)funcEnv);
        List<SymbolMetaInfo> visibleEPSymbols = this.resolveVisibleEndpointSymbols(funcBodyEnv, funcNode);
        this.visibleEPsByNode.put((BLangNode)funcNode.body, visibleEPSymbols);
        this.acceptNode((BLangNode)funcNode.body, funcBodyEnv);
    }

    @Override
    public void visit(BLangService serviceNode) {
        SymbolEnv serviceEnv = SymbolEnv.createServiceEnv((BLangService)serviceNode, (Scope)serviceNode.symbol.scope, (SymbolEnv)this.symbolEnv);
        ((BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode).getFunctions().stream().filter(bLangFunction -> (bLangFunction.symbol.flags & 0x40000) == 262144).forEach(bLangFunction -> this.acceptNode((BLangNode)bLangFunction, serviceEnv));
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        this.resolveEndpointsFromStatements(blockNode.stmts, (BLangNode)blockNode);
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        this.resolveEndpointsFromStatements(blockFuncBody.stmts, (BLangNode)blockFuncBody);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.acceptNode((BLangNode)ifNode.body, this.symbolEnv);
        this.acceptNode((BLangNode)ifNode.elseStmt, this.symbolEnv);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.acceptNode((BLangNode)whileNode.body, this.symbolEnv);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.acceptNode((BLangNode)foreach.body, this.symbolEnv);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.acceptNode((BLangNode)transactionNode.transactionBody, this.symbolEnv);
        this.acceptNode((BLangNode)transactionNode.onRetryBody, this.symbolEnv);
        this.acceptNode((BLangNode)transactionNode.committedBody, this.symbolEnv);
        this.acceptNode((BLangNode)transactionNode.abortedBody, this.symbolEnv);
    }

    private void acceptNode(BLangNode node, SymbolEnv env) {
        if (node == null) {
            return;
        }
        SymbolEnv prevEnv = this.symbolEnv;
        this.symbolEnv = env;
        node.accept((BLangNodeVisitor)this);
        this.symbolEnv = prevEnv;
    }

    private List<SymbolMetaInfo> resolveVisibleEndpointSymbols(SymbolEnv symbolEnv, BLangFunction ownerFunction) {
        List parameters = ownerFunction.getParameters().stream().map(bLangSimpleVariable -> bLangSimpleVariable.symbol).collect(Collectors.toList());
        ArrayList visibleSymbols = new ArrayList();
        this.symbolResolver.getAllVisibleInScopeSymbols(symbolEnv).forEach((key, value) -> visibleSymbols.addAll(value.stream().map(scopeEntry -> scopeEntry.symbol).collect(Collectors.toList())));
        return visibleSymbols.stream().filter(symbol -> symbol instanceof BVarSymbol && CommonUtil.isClientObject(symbol) && (parameters.contains(symbol) || symbol.owner instanceof BPackageSymbol)).map(symbol -> {
            BLangImportPackage importPackage = this.packageMap.get(symbol.type.tsymbol.pkgID);
            String typeName = symbol.type.tsymbol.getName().getValue();
            String pkgName = symbol.pkgID.getName().getValue();
            String orgName = symbol.pkgID.getOrgName().getValue();
            String alias = importPackage == null ? "" : importPackage.getAlias().getValue();
            boolean isCaller = parameters.contains(symbol);
            return new SymbolMetaInfo.SymbolMetaInfoBuilder().setName(symbol.getName().getValue()).setPkgName(pkgName).setPkgOrgName(orgName).setPkgAlias(alias).setKind("VisibleEndpoint").setCaller(isCaller).setTypeName(typeName).setLocal(false).build();
        }).collect(Collectors.toList());
    }

    private void resolveEndpointsFromStatements(List<BLangStatement> statements, BLangNode owner) {
        statements.forEach(stmt -> {
            if (stmt instanceof BLangSimpleVariableDef) {
                BVarSymbol symbol = ((BLangSimpleVariableDef)stmt).var.symbol;
                if (CommonUtil.isClientObject((BSymbol)symbol)) {
                    BLangImportPackage importPackage = this.packageMap.get(symbol.type.tsymbol.pkgID);
                    String typeName = symbol.type.tsymbol.getName().getValue();
                    String pkgName = symbol.pkgID.getName().getValue();
                    String orgName = symbol.pkgID.getOrgName().getValue();
                    String alias = importPackage == null ? "" : importPackage.getAlias().getValue();
                    SymbolMetaInfo visibleEndpoint = new SymbolMetaInfo.SymbolMetaInfoBuilder().setName(symbol.getName().getValue()).setPkgName(pkgName).setPkgOrgName(orgName).setPkgAlias(alias).setKind("VisibleEndpoint").setCaller(false).setTypeName(typeName).setLocal(true).setPos(stmt.pos).build();
                    if (this.visibleEPsByNode.containsKey(owner)) {
                        this.visibleEPsByNode.get(owner).add(visibleEndpoint);
                    } else {
                        this.visibleEPsByNode.put(owner, Collections.singletonList(visibleEndpoint));
                    }
                }
            } else {
                stmt.accept((BLangNodeVisitor)this);
            }
        });
    }
}

